/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertExtension;
import th.co.oga.security.pki.Certification.Extension.CRLDistributionPoints;
import th.co.oga.security.pki.OIDs;

public class CertExtensionCRLDP
extends CertExtension {
    private static String OID = OIDs.ceCRLDistributionPoints;
    private static boolean critical = false;
    private List priorities = new ArrayList();
    private CRLDistributionPoints dnp;

    public CertExtensionCRLDP(byte[] bytes) throws ASN1Exception {
        super(OID, critical, bytes);
        this.priorities.add("HTTP");
        this.priorities.add("HTTPS");
        this.priorities.add("LDAP");
        this.priorities.add("LDAPS");
        this.dnp = CRLDistributionPoints.getInstance(bytes);
    }

    public URL getURL() throws ASN1Exception {
        try {
            URL[] urls = this.dnp.getURLs();
            int pointer = -1;
            int maxpoint = -1;
            if (urls != null) {
                int u = 0;
                while (u < urls.length) {
                    int point = this.priorities.indexOf(urls[u].getProtocol().toUpperCase());
                    if (maxpoint < point) {
                        maxpoint = point;
                        pointer = u;
                    }
                    ++u;
                }
            }
            if (pointer > -1) {
                return urls[pointer];
            }
            return null;
        }
        catch (Exception e) {
            throw new ASN1Exception(e.toString());
        }
    }

    public static boolean isMe(String oid) {
        return OID.equals(oid);
    }

    public String getData() throws ASN1Exception {
        return this.dnp.getData();
    }
}

