/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.Extension.DistributionPoint;
import th.co.oga.security.pki.Certification.Extension.PolicyInformation;

public class CertificatePolicies
implements ASN1Value {
    private SEQUENCE pls;
    public static final Tag TAG = SEQUENCE.TAG;

    private CertificatePolicies() {
    }

    CertificatePolicies(SEQUENCE seq) {
        this.pls = seq;
    }

    public void add(DistributionPoint dn) {
        this.pls.addElement((ASN1Value)dn);
    }

    public PolicyInformation at(int idx) {
        return (PolicyInformation)this.pls.elementAt(idx);
    }

    public int size() {
        return this.pls.size();
    }

    public String getData() throws ASN1Exception {
        try {
            StringWriter sw = new StringWriter();
            sw.write("\r\n");
            int i = 0;
            while (i < this.pls.size()) {
                sw.write("[" + (i + 1) + "]Certificate Policy\r\n");
                sw.write(this.at(i).getData());
                ++i;
            }
            return sw.toString();
        }
        catch (Exception e) {
            throw new ASN1Exception(e.toString());
        }
    }

    public URL[] getCPSURLs() throws InvalidBERException, URISyntaxException {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<URL> urls = new ArrayList<URL>();
        int i = 0;
        while (i < this.pls.size()) {
            List subList = this.at(i).getCPSURLs();
            int s = 0;
            while (s < subList.size()) {
                list.add((String)subList.get(s));
                ++s;
            }
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            URI uri = new URI((String)list.get(i));
            try {
                urls.add(uri.toURL());
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++i;
        }
        if (urls.size() > 0) {
            URL[] rtn = new URL[urls.size()];
            int r = 0;
            while (r < urls.size()) {
                rtn[r] = (URL)urls.get(r);
                ++r;
            }
            return rtn;
        }
        return null;
    }

    public String getPolicyID() {
        String rtn = null;
        int i = 0;
        while (i < this.pls.size()) {
            rtn = this.at(i).getPolicyID();
            if (rtn != null) break;
            ++i;
        }
        return rtn;
    }

    public static CertificatePolicies getInstance(byte[] extensionValue) throws ASN1Exception {
        try {
            OCTET_STRING otStr = (OCTET_STRING)ASN1Util.decode((ASN1Template)OCTET_STRING.getTemplate(), (byte[])extensionValue);
            Template template = new Template();
            return (CertificatePolicies)new Template().decode(new ByteArrayInputStream(otStr.toByteArray()));
        }
        catch (Exception e) {
            throw new ASN1Exception(e.getMessage());
        }
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.pls.encode(ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.pls.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.OF_Template seqq = new SEQUENCE.OF_Template((ASN1Template)new PolicyInformation.Template());
            SEQUENCE seq = (SEQUENCE)seqq.decode(implicit, istream);
            if (seq.size() < 1) {
                throw new InvalidBERException("PolicyInformation with zero elements, an PolicyInformation must have at least one element");
            }
            return new CertificatePolicies(seq);
        }
    }
}

