/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.List;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.Certification.Extension.DistributionPointName;
import th.co.oga.security.pki.Certification.Extension.GeneralNames;

public class DistributionPoint
implements ASN1Value {
    private BIT_STRING reasons;
    private GeneralNames cRLIssuer;
    private DistributionPointName dpn;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    protected DistributionPoint(DistributionPointName dn, BIT_STRING reasonFlags, GeneralNames crlIssuer) {
        this.reasons = reasonFlags;
        this.cRLIssuer = crlIssuer;
        this.dpn = dn;
    }

    public String getData() throws InvalidBERException, URISyntaxException {
        return String.valueOf(this.dpn == null ? "" : "Distribution Point Name:\r\n" + this.dpn.getData()) + (this.cRLIssuer == null ? "" : "CRL Issuer:\r\n" + this.cRLIssuer.getData());
    }

    public List getURLs() throws InvalidBERException, URISyntaxException {
        return this.dpn == null ? null : this.dpn.getURLs();
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.dpn);
        seq.addElement((ASN1Value)this.reasons);
        seq.addElement((ASN1Value)this.cRLIssuer);
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addOptionalElement((ASN1Template)DistributionPointName.getTemplate());
            this.seqt.addOptionalElement(new Tag(1L), (ASN1Template)BIT_STRING.getTemplate());
            this.seqt.addOptionalElement(new Tag(2L), (ASN1Template)new GeneralNames.Template());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            return new DistributionPoint((DistributionPointName)seq.elementAt(0), (BIT_STRING)seq.elementAt(1), (GeneralNames)seq.elementAt(2));
        }
    }
}

