/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.IA5String;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AVA;
import org.mozilla.jss.pkix.primitive.RDN;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.Certification.Extension.GeneralName;
import th.co.oga.security.pki.Certification.Extension.GeneralNames;

public class DistributionPointName
implements ASN1Value {
    private ASN1Value dn;
    private static final Template TEMPLATE = new Template();

    protected DistributionPointName(ASN1Value dn) {
        this.dn = dn;
    }

    protected DistributionPointName(GeneralName gn) {
        this.dn = gn;
    }

    protected DistributionPointName(RDN rdn) {
        this.dn = rdn;
    }

    protected DistributionPointName(String fullName) throws CharConversionException {
        this.dn = new IA5String(fullName);
    }

    public String getData() throws InvalidBERException, URISyntaxException {
        if (this.dn instanceof GeneralNames) {
            return "Full Name:\r\n" + ((GeneralNames)this.dn).getData();
        }
        if (this.dn instanceof RDN) {
            String rdnStr = "Reletived Distinguished Name:\r\n";
            RDN rdn = (RDN)this.dn;
            int i = 0;
            while (i < rdn.size()) {
                AVA ava = rdn.at(i);
                rdnStr = String.valueOf(rdnStr) + ava.getOID().toString() + "=" + new String(ava.getValue().getContents()) + "\r\n";
                ++i;
            }
            return rdnStr;
        }
        return new String(((ANY)this.dn).getContents());
    }

    public List getURLs() throws InvalidBERException, URISyntaxException {
        if (this.dn instanceof GeneralNames) {
            return ((GeneralNames)this.dn).getURLs();
        }
        String rdnStr = "";
        RDN rdn = (RDN)this.dn;
        int i = 0;
        while (i < rdn.size()) {
            AVA ava = rdn.at(i);
            if (i > 0) {
                rdnStr = String.valueOf(rdnStr) + ", ";
            }
            rdnStr = String.valueOf(rdnStr) + ava.getOID().toString() + "=" + new String(ava.getValue().getContents());
            ++i;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(rdnStr);
        return list;
    }

    public Tag getTag() {
        return this.dn.getTag();
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.dn.encode(implicit, ostream);
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template cTP = new CHOICE.Template();

        public Template() {
            this.cTP.addElement(new Tag(0L), (ASN1Template)new GeneralNames.Template());
            this.cTP.addElement(new Tag(1L), (ASN1Template)new RDN.Template());
        }

        public boolean tagMatch(Tag tag) {
            return this.cTP.tagMatch(tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            CHOICE choice = (CHOICE)this.cTP.decode(istream);
            return new DistributionPointName(choice.getValue());
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            Assert._assert((boolean)this.tagMatch(implicit));
            return this.decode(istream);
        }
    }
}

