/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.DirectoryString;

public class EDIPartyName
implements ASN1Value {
    private DirectoryString assigner;
    private DirectoryString party;
    public static final Tag TAG = new Tag(6L);
    private static final Template TEMPLATE = new Template();

    protected EDIPartyName(DirectoryString assigner, DirectoryString party) throws InvalidBERException {
        this.assigner = assigner;
        this.party = party;
    }

    public String getNameAssigner() {
        return this.assigner.toString();
    }

    public String getPartyName() {
        return this.assigner.toString();
    }

    public String getData() {
        return "Name Assigner=" + this.getNameAssigner() + "\r\nParty Name=" + this.getPartyName();
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.assigner);
        seq.addElement((ASN1Value)this.party);
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)DirectoryString.getTemplate());
            this.seqt.addElement((ASN1Template)DirectoryString.getTemplate());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            return new EDIPartyName((DirectoryString)seq.elementAt(0), (DirectoryString)seq.elementAt(1));
        }
    }
}

