/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;
import th.co.oga.security.pki.Certification.Extension.NumericString;
import th.co.oga.security.pki.Certification.Extension.PresentationAddress;

public class ExtendedNetworkAddress
implements ASN1Value {
    private ASN1Value ena;
    private static final Template TEMPLATE = new Template();

    protected ExtendedNetworkAddress(ASN1Value ena) throws InvalidBERException {
        this.ena = ena;
    }

    protected ExtendedNetworkAddress(SEQUENCE seq) throws InvalidBERException {
        this.ena = seq;
    }

    protected ExtendedNetworkAddress(PresentationAddress pa) throws InvalidBERException {
        this.ena = pa;
    }

    public ASN1Value getValue() {
        return this.ena;
    }

    public String getData() {
        SEQUENCE seq = (SEQUENCE)this.ena;
        NumericString ns1 = (NumericString)seq.elementAt(0);
        NumericString ns2 = (NumericString)seq.elementAt(1);
        return String.valueOf(ns1.getData()) + " " + (ns2 == null ? "" : ns2.getData());
    }

    public static SEQUENCE.Template getE1634addressTemplate() {
        NumericString.Template nT = new NumericString.Template();
        SEQUENCE.Template sT = SEQUENCE.getTemplate();
        sT.addElement((ASN1Template)nT);
        sT.addOptionalElement((ASN1Template)nT);
        return sT;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.ena.encode(implicit, ostream);
    }

    public Tag getTag() {
        return this.ena.getTag();
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template cTP = CHOICE.getTemplate();

        public Template() {
            this.cTP.addElement((ASN1Template)ExtendedNetworkAddress.getE1634addressTemplate());
            this.cTP.addElement((ASN1Template)new PresentationAddress.Template());
        }

        public boolean tagMatch(Tag tag) {
            return this.cTP.tagMatch(tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            CHOICE choice = (CHOICE)this.cTP.decode(istream);
            return new ExtendedNetworkAddress(choice.getValue());
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            Assert._assert((boolean)this.tagMatch(implicitTag));
            return this.decode(istream);
        }
    }
}

