/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class ExtensionAttribute
implements ASN1Value {
    private PrintableString type;
    private ANY value;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    protected ExtensionAttribute(PrintableString type, ANY value) {
        this.type = type;
        this.value = value;
    }

    public String getType() {
        return this.type.toString();
    }

    public String getValue() throws InvalidBERException {
        return new String(this.value.getContents());
    }

    public String getData() throws InvalidBERException {
        return String.valueOf(this.getType()) + "=" + this.getValue();
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.type);
        seq.addElement((ASN1Value)this.value);
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)PrintableString.getTemplate());
            this.seqt.addElement((ASN1Template)ANY.getTemplate());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            return new ExtensionAttribute((PrintableString)seq.elementAt(0), (ANY)seq.elementAt(1));
        }
    }
}

