/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.TooFewElementsException;
import th.co.oga.security.pki.Certification.Extension.ExtensionAttribute;
import th.co.oga.security.pki.Certification.Extension.NumericString;

public class ExtensionAttributes
implements ASN1Value {
    private SET ous;
    public static final Tag TAG = SET.TAG;

    private ExtensionAttributes() {
    }

    public ExtensionAttributes(NumericString n) {
        this.ous = new SEQUENCE();
        this.ous.addElement((ASN1Value)n);
    }

    ExtensionAttributes(SET set) {
        this.ous = set;
    }

    public void add(NumericString n) {
        this.ous.addElement((ASN1Value)n);
    }

    public PrintableString at(int idx) {
        return (PrintableString)this.ous.elementAt(idx);
    }

    public String getData() throws InvalidBERException {
        StringWriter str = new StringWriter();
        int i = 0;
        while (i < this.size()) {
            str.write(String.valueOf(i > 0 ? ", " : "") + this.at(i).toString());
            ++i;
        }
        return str.toString();
    }

    public void removeAt(int idx) throws TooFewElementsException {
        if (this.ous.size() <= 1) {
            throw new TooFewElementsException();
        }
        this.ous.removeElementAt(idx);
    }

    public int size() {
        return this.ous.size();
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.ous.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.ous.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SET.OF_Template sett = new SET.OF_Template((ASN1Template)new ExtensionAttribute.Template());
            SET set = (SET)sett.decode(implicit, istream);
            if (set.size() < 1) {
                throw new InvalidBERException("BuiltInDomainDefinedAttributes with zero elements, an BuiltInDomainDefinedAttributes must have at least one element");
            }
            return new ExtensionAttributes(set);
        }
    }
}

