/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.IA5String;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.Certification.Extension.EDIPartyName;
import th.co.oga.security.pki.Certification.Extension.ORAddress;
import th.co.oga.security.pki.Certification.Extension.OtherName;
import th.co.oga.security.pki.Certification.Extension.URIString;
import th.co.oga.security.pki.x.DirectoryName;

public class GeneralName
implements ASN1Value {
    private ASN1Value gn;
    private static final Template TEMPLATE = new Template();

    public GeneralName(ASN1Value generalName) throws InvalidBERException {
        this.gn = generalName;
    }

    public ASN1Value getValue() {
        return this.gn;
    }

    public String getData() throws InvalidBERException, URISyntaxException {
        String data = "";
        if (this.gn instanceof URIString) {
            data = ((URIString)this.gn).getData();
        } else if (this.gn instanceof IA5String) {
            data = ((IA5String)this.gn).toString();
        } else if (this.gn instanceof OtherName) {
            data = ((OtherName)this.gn).getData();
        } else if (this.gn instanceof EDIPartyName) {
            data = ((EDIPartyName)this.gn).getData();
        } else if (this.gn instanceof ORAddress) {
            data = ((ORAddress)this.gn).getData();
        } else if (this.gn instanceof DirectoryName) {
            data = ((DirectoryName)this.gn).getData();
        } else if (this.gn instanceof OBJECT_IDENTIFIER) {
            data = ((OBJECT_IDENTIFIER)this.gn).toString();
        } else {
            ANY any = (ANY)this.gn;
            data = new String(any.getContents());
        }
        return data;
    }

    public String getURL() throws InvalidBERException, URISyntaxException {
        String data = null;
        if (this.gn instanceof URIString) {
            data = ((URIString)this.gn).getData();
        }
        return data;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(this.getTag(), ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.gn.encode(implicit, ostream);
    }

    public Tag getTag() {
        return this.gn.getTag();
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template cTP = CHOICE.getTemplate();

        public Template() {
            this.cTP.addElement(new Tag(0L), (ASN1Template)new OtherName.Template());
            this.cTP.addElement(new Tag(1L), (ASN1Template)new IA5String.Template());
            this.cTP.addElement(new Tag(2L), (ASN1Template)new IA5String.Template());
            this.cTP.addElement(new Tag(3L), (ASN1Template)new ORAddress.Template());
            this.cTP.addElement(new Tag(4L), (ASN1Template)new DirectoryName.Template());
            this.cTP.addElement(new Tag(5L), (ASN1Template)new EDIPartyName.Template());
            this.cTP.addElement(new Tag(6L), (ASN1Template)new URIString.Template());
            this.cTP.addElement(new Tag(7L), (ASN1Template)new OCTET_STRING.Template());
            this.cTP.addElement(new Tag(8L), (ASN1Template)new OBJECT_IDENTIFIER.Template());
        }

        public boolean tagMatch(Tag tag) {
            return this.cTP.tagMatch(tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            CHOICE choice = (CHOICE)this.cTP.decode(istream);
            return new GeneralName(choice.getValue());
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            CHOICE choice = (CHOICE)this.cTP.decode(implicitTag, istream);
            return new GeneralName(choice.getValue());
        }
    }
}

