/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.Certification.Extension.GeneralName;

public class GeneralNames
implements ASN1Value {
    private SEQUENCE gns;
    public static final Tag TAG = SEQUENCE.TAG;

    private GeneralNames() {
    }

    public GeneralNames(GeneralName n) {
        this.gns = new SEQUENCE();
        this.gns.addElement((ASN1Value)n);
    }

    GeneralNames(SEQUENCE seq) {
        this.gns = seq;
    }

    public GeneralName at(int idx) {
        return (GeneralName)this.gns.elementAt(idx);
    }

    public int size() {
        return this.gns.size();
    }

    public String getData() throws InvalidBERException, URISyntaxException {
        StringWriter str = new StringWriter();
        int i = 0;
        while (i < this.size()) {
            str.write(String.valueOf(this.at(i).getData()) + "\r\n");
            ++i;
        }
        return str.toString();
    }

    public List getURLs() throws InvalidBERException, URISyntaxException {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < this.size()) {
            if (this.at(i).getURL() != null) {
                list.add(this.at(i).getURL());
            }
            ++i;
        }
        return list;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.gns.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.gns.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.OF_Template seqq = new SEQUENCE.OF_Template((ASN1Template)new ANY.Template());
            SEQUENCE seq = (SEQUENCE)seqq.decode(implicit, istream);
            if (seq.size() < 1) {
                throw new InvalidBERException("GeneralNames with zero elements, an GeneralNames must have at least one element");
            }
            ANY any = (ANY)seq.elementAt(0);
            byte[] gnRaw = any.getContents();
            SEQUENCE xseq = (SEQUENCE)any.decodeWith(new Tag(0L), (ASN1Template)new SEQUENCE.OF_Template((ASN1Template)GeneralName.getTemplate()));
            return new GeneralNames(xseq);
        }
    }
}

