/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.x.DisplayText;

public class NoticeReference
implements ASN1Value {
    private DisplayText organization;
    private SEQUENCE noticeNumbers;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    protected NoticeReference(DisplayText org, SEQUENCE noticeNumbers) {
        this.organization = org;
        this.noticeNumbers = noticeNumbers;
    }

    public String getData() throws InvalidBERException {
        StringWriter sw = new StringWriter();
        sw.write(this.organization.getData());
        if (this.noticeNumbers.size() > 0) {
            sw.write("\r\n\tNotice Numbers");
            int i = 0;
            while (i < this.noticeNumbers.size()) {
                sw.write("" + ((INTEGER)this.noticeNumbers.elementAt(i)).intValue());
                ++i;
            }
        }
        return sw.toString();
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.organization);
        seq.addElement((ASN1Value)this.noticeNumbers);
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)DisplayText.getTemplate());
            this.seqt.addElement((ASN1Template)SEQUENCE.getTemplate());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            return new NoticeReference((DisplayText)seq.elementAt(0), (SEQUENCE)seq.elementAt(1));
        }
    }
}

