/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.Tag;

public class NumericString
implements ASN1Value {
    static final Form FORM = Form.PRIMITIVE;
    private char[] chars;
    public static final Tag TAG = new Tag(Tag.UNIVERSAL, 18L);

    public NumericString(char[] chars) throws CharConversionException {
        this.chars = chars;
    }

    public NumericString(String s) throws CharConversionException {
        this.chars = s.toCharArray();
    }

    public String getData() {
        return new String(this.chars);
    }

    public Tag getTag() {
        return new Tag(Tag.UNIVERSAL, 18L);
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        byte[] contents = new String(this.chars).getBytes();
        ASN1Header head = new ASN1Header(implicitTag, FORM, (long)contents.length);
        head.encode(ostream);
        ostream.write(contents);
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws IOException, InvalidBERException {
            try {
                byte[] raw;
                ASN1Header head = new ASN1Header(istream);
                head.validate(implicitTag);
                if (head.getContentLength() == -1L) {
                    ASN1Header ahead;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    do {
                        if ((ahead = ASN1Header.lookAhead((InputStream)istream)).isEOC()) continue;
                        OCTET_STRING.Template ot = new OCTET_STRING.Template();
                        OCTET_STRING os = (OCTET_STRING)ot.decode(istream);
                        bos.write(os.toByteArray());
                    } while (!ahead.isEOC());
                    ahead = new ASN1Header(istream);
                    raw = bos.toByteArray();
                } else {
                    raw = new byte[(int)head.getContentLength()];
                    ASN1Util.readFully((byte[])raw, (InputStream)istream);
                }
                return new NumericString(new String(raw).toCharArray());
            }
            catch (CharConversionException e) {
                throw new InvalidBERException(e.getMessage());
            }
            catch (InvalidBERException e) {
                throw new InvalidBERException(e, "NumericString");
            }
        }
    }
}

