/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.Certification.Extension.BuiltInDomainDefinedAttributes;
import th.co.oga.security.pki.Certification.Extension.BuiltInStandardAttributes;
import th.co.oga.security.pki.Certification.Extension.ExtensionAttributes;

public class ORAddress
implements ASN1Value {
    private BuiltInStandardAttributes bisas;
    private BuiltInDomainDefinedAttributes bidas;
    private ExtensionAttributes eas;
    public static final Tag TAG = SEQUENCE.TAG;

    private ORAddress() {
    }

    ORAddress(BuiltInStandardAttributes bisas, BuiltInDomainDefinedAttributes bidas, ExtensionAttributes eas) {
        this.bisas = bisas;
        this.bidas = bidas;
        this.eas = eas;
    }

    public String getData() throws InvalidBERException {
        return "BuiltInStandardAttributes:" + this.bisas.getData() + "\r\n" + (this.bidas == null ? "" : "BuiltInDomainDefinedAttributes:" + this.bidas.getData() + "\r\n") + (this.eas == null ? "" : "ExtensionAttributes:" + this.eas.getData() + "\r\n");
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.bisas);
        seq.addElement((ASN1Value)this.bidas);
        seq.addElement((ASN1Value)this.eas);
        seq.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)BuiltInStandardAttributes.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)new BuiltInDomainDefinedAttributes.Template());
            this.seqt.addOptionalElement((ASN1Template)new ExtensionAttributes.Template());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            if (seq.size() < 1) {
                throw new InvalidBERException("ORAddress with zero elements, an ORAddress must have at least one element");
            }
            return new ORAddress((BuiltInStandardAttributes)seq.elementAt(0), (BuiltInDomainDefinedAttributes)seq.elementAt(1), (ExtensionAttributes)seq.elementAt(2));
        }
    }
}

