/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.OIDs;

public class OtherName
implements ASN1Value {
    private OBJECT_IDENTIFIER type_id;
    private ANY value;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    protected OtherName(String oid, byte[] value) throws InvalidBERException {
        this.type_id = new OBJECT_IDENTIFIER(oid);
        this.value = new ANY(value);
    }

    private OtherName(OBJECT_IDENTIFIER oid, ASN1Value ex) throws InvalidBERException {
        this.type_id = oid;
        if (ex != null) {
            this.value = (ANY)((EXPLICIT)ex).getContent();
        }
    }

    public byte[] getBytes() throws InvalidBERException {
        return this.value.getContents();
    }

    public String getOID() {
        return OIDs.fromLongs(this.type_id.getNumbers());
    }

    public String getData() throws InvalidBERException {
        return String.valueOf(this.getOID()) + "=" + new String(this.getBytes());
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.type_id);
        seq.addElement((ASN1Value)this.value);
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    /* synthetic */ OtherName(OBJECT_IDENTIFIER oBJECT_IDENTIFIER, ASN1Value aSN1Value, OtherName otherName) throws InvalidBERException {
        this(oBJECT_IDENTIFIER, aSN1Value);
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement((ASN1Template)new EXPLICIT.Template(new Tag(0L), (ASN1Template)ANY.getTemplate()));
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            int len = 0;
            if (seq.elementAt(1) != null) {
                len = ((INTEGER)seq.elementAt(1)).intValue();
            }
            return new OtherName((OBJECT_IDENTIFIER)seq.elementAt(0), seq.elementAt(1), null);
        }
    }
}

