/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.List;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.Certification.Extension.PolicyQualifiers;
import th.co.oga.security.pki.OIDs;

public class PolicyInformation
implements ASN1Value {
    private OBJECT_IDENTIFIER policyId;
    private PolicyQualifiers policyQualifiers;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    protected PolicyInformation(OBJECT_IDENTIFIER policyId, PolicyQualifiers policyQualifiers) {
        this.policyId = policyId;
        this.policyQualifiers = policyQualifiers;
    }

    public String getData() throws InvalidBERException, URISyntaxException {
        StringWriter sw = new StringWriter();
        sw.write("Policy Identifier:" + OIDs.fromLongs(this.policyId.getNumbers()));
        if (this.policyQualifiers != null) {
            sw.write("\r\n\t" + this.policyQualifiers.getData());
        }
        return sw.toString();
    }

    public List getCPSURLs() throws InvalidBERException, URISyntaxException {
        if (this.policyQualifiers != null) {
            return this.policyQualifiers.getCPSURLs();
        }
        return null;
    }

    public String getPolicyID() {
        return OIDs.fromLongs(this.policyId.getNumbers());
    }

    public String getUserNotice() throws InvalidBERException {
        if (this.policyQualifiers != null) {
            return this.policyQualifiers.getUserNotice();
        }
        return null;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.policyId);
        seq.addElement((ASN1Value)this.policyQualifiers);
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)new PolicyQualifiers.Template());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            PolicyQualifiers pQualifiers = null;
            if (seq.elementAt(1) != null) {
                pQualifiers = (PolicyQualifiers)seq.elementAt(1);
            }
            return new PolicyInformation((OBJECT_IDENTIFIER)seq.elementAt(0), pQualifiers);
        }
    }
}

