/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.Certification.Extension.Qualifier;
import th.co.oga.security.pki.OIDs;

public class PolicyQualifierInfo
implements ASN1Value {
    public static String TYPE_CPS = "CPS";
    public static String TYPE_UNOTICE = "User Notice";
    private static String CPS_OID = OIDs.qtCPS;
    private static String UNOTICE_OID = OIDs.qtUnotice;
    private OBJECT_IDENTIFIER policyQualifierId;
    private Qualifier qualifier;
    private ASN1Value ql;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    protected PolicyQualifierInfo(OBJECT_IDENTIFIER id, Qualifier value) {
        this.policyQualifierId = id;
        this.qualifier = value;
    }

    protected PolicyQualifierInfo(OBJECT_IDENTIFIER id, ASN1Value ql) {
        this.policyQualifierId = id;
        this.ql = ql;
    }

    public String getType() {
        String oid = this.getOID();
        if (CPS_OID.equals(oid)) {
            return TYPE_CPS;
        }
        if (UNOTICE_OID.equals(oid)) {
            return TYPE_UNOTICE;
        }
        return "Undefine";
    }

    public String getCPSURL() throws InvalidBERException {
        if (CPS_OID.equals(this.getOID())) {
            return this.qualifier.getData();
        }
        return null;
    }

    public String getUserNotice() throws InvalidBERException {
        if (UNOTICE_OID.equals(this.getOID())) {
            return this.qualifier.getData();
        }
        return null;
    }

    public String getOID() {
        return OIDs.fromLongs(this.policyQualifierId.getNumbers());
    }

    public String getData() throws InvalidBERException, URISyntaxException {
        return String.valueOf(this.getType()) + "=" + this.qualifier.getData();
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.policyQualifierId);
        seq.addElement((ASN1Value)this.qualifier);
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement((ASN1Template)Qualifier.getTemplate());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            Qualifier ql = (Qualifier)seq.elementAt(1);
            return new PolicyQualifierInfo((OBJECT_IDENTIFIER)seq.elementAt(0), ql);
        }
    }
}

