/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.Certification.Extension.PolicyQualifierInfo;

public class PolicyQualifiers
implements ASN1Value {
    private SEQUENCE qis;
    public static final Tag TAG = SEQUENCE.TAG;

    private PolicyQualifiers() {
    }

    public PolicyQualifiers(PolicyQualifierInfo n) {
        this.qis = new SEQUENCE();
        this.qis.addElement((ASN1Value)n);
    }

    PolicyQualifiers(SEQUENCE seq) {
        this.qis = seq;
    }

    public PolicyQualifierInfo at(int idx) {
        return (PolicyQualifierInfo)this.qis.elementAt(idx);
    }

    public int size() {
        return this.qis.size();
    }

    public String getData() throws InvalidBERException, URISyntaxException {
        StringWriter str = new StringWriter();
        int i = 0;
        while (i < this.size()) {
            str.write(String.valueOf(this.at(i).getData()) + "\r\n");
            ++i;
        }
        return str.toString();
    }

    public List getCPSURLs() throws URISyntaxException, InvalidBERException {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < this.size()) {
            String url = this.at(i).getCPSURL();
            if (url != null) {
                list.add(url);
            }
            ++i;
        }
        return list;
    }

    public String getUserNotice() throws InvalidBERException {
        StringWriter sw = new StringWriter();
        int i = 0;
        while (i < this.size()) {
            String notice = this.at(i).getUserNotice();
            if (notice != null) {
                sw.write("\r\n" + notice);
            }
            ++i;
        }
        return sw.toString();
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.qis.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.qis.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.OF_Template seqq = new SEQUENCE.OF_Template((ASN1Template)new PolicyQualifierInfo.Template());
            SEQUENCE seq = (SEQUENCE)seqq.decode(implicit, istream);
            if (seq.size() < 1) {
                throw new InvalidBERException("PolicyQualifiers with zero elements, an PolicyQualifiers must have at least one element");
            }
            return new PolicyQualifiers(seq);
        }
    }
}

