/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.Extension.NAddresses;

public class PresentationAddress
implements ASN1Value {
    private OCTET_STRING pSelector;
    private OCTET_STRING sSelector;
    private OCTET_STRING tSelector;
    private NAddresses nAddresses;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    protected PresentationAddress(OCTET_STRING ps, OCTET_STRING ss, OCTET_STRING ts, NAddresses na) {
        this.pSelector = ps;
        this.sSelector = ss;
        this.tSelector = ts;
        this.nAddresses = na;
    }

    public String getData() throws ASN1Exception {
        StringWriter sw = new StringWriter();
        if (this.pSelector != null) {
            sw.write(new String(this.pSelector.toByteArray()));
        }
        if (this.sSelector != null) {
            sw.write(new String(this.sSelector.toByteArray()));
        }
        if (this.tSelector != null) {
            sw.write(new String(this.tSelector.toByteArray()));
        }
        if (this.nAddresses != null) {
            sw.write(this.nAddresses.getData());
        }
        return sw.toString();
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.pSelector);
        seq.addElement((ASN1Value)this.sSelector);
        seq.addElement((ASN1Value)this.tSelector);
        seq.addElement((ASN1Value)this.nAddresses);
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqT;

        public Template() {
            EXPLICIT.Template exOCT = EXPLICIT.getTemplate((Tag)OCTET_STRING.TAG, (ASN1Template)OCTET_STRING.getTemplate());
            this.seqT = new SEQUENCE.Template();
            this.seqT.addOptionalElement((ASN1Template)exOCT);
            this.seqT.addOptionalElement((ASN1Template)exOCT);
            this.seqT.addOptionalElement((ASN1Template)exOCT);
            this.seqT.addOptionalElement((ASN1Template)EXPLICIT.getTemplate((Tag)NAddresses.TAG, (ASN1Template)new NAddresses.Template()));
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqT.decode(implicit, istream);
            OCTET_STRING pSelector = seq.elementAt(0) != null ? (OCTET_STRING)seq.elementAt(0) : null;
            OCTET_STRING sSelector = seq.elementAt(1) != null ? (OCTET_STRING)seq.elementAt(1) : null;
            OCTET_STRING tSelector = seq.elementAt(2) != null ? (OCTET_STRING)seq.elementAt(2) : null;
            NAddresses nAddresses = seq.elementAt(3) != null ? (NAddresses)seq.elementAt(3) : null;
            return new PresentationAddress(pSelector, sSelector, tSelector, nAddresses);
        }
    }
}

