/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertExtension;
import th.co.oga.security.pki.OIDs;

public class SubjectKeyIdentifier
extends CertExtension
implements ASN1Value {
    private static String OID = OIDs.ceSubjectKeyIdentifier;
    private static boolean critical = false;
    public static final Tag TAG = OCTET_STRING.TAG;

    public SubjectKeyIdentifier(byte[] bytes) throws ASN1Exception {
        super(OID, critical, bytes);
    }

    public static boolean isMe(String oid) {
        return OID.equals(oid);
    }

    public String getData() throws ASN1Exception {
        return new String(this.getValue());
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        OCTET_STRING content = this.getExtnValue();
        content.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            OCTET_STRING content = (OCTET_STRING)OCTET_STRING.getTemplate().decode(istream);
            byte[] value = ASN1Util.encode((ASN1Value)content);
            try {
                return new SubjectKeyIdentifier(value);
            }
            catch (ASN1Exception e) {
                throw new InvalidBERException(e.getMessage());
            }
        }
    }
}

