/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.IA5String;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class URIString
implements ASN1Value {
    private IA5String value;
    public static final Tag TAG = IA5String.TAG;
    private static final Template TEMPLATE = new Template();

    protected URIString(IA5String ia5Str) throws InvalidBERException {
        this.value = ia5Str;
    }

    public String toString() {
        return this.value.toString();
    }

    public URI getURI() throws URISyntaxException {
        return new URI(this.toString());
    }

    public String getData() throws InvalidBERException, URISyntaxException {
        return this.getURI().toString();
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.value.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt;

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            IA5String ia5Str = (IA5String)IA5String.getTemplate().decode(implicit, istream);
            return new URIString(ia5Str);
        }
    }
}

