/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification.Extension;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import th.co.oga.security.pki.Certification.Extension.NoticeReference;
import th.co.oga.security.pki.x.DisplayText;

public class UserNotice
implements ASN1Value {
    private DisplayText explicitText;
    private NoticeReference noticeRef;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template TEMPLATE = new Template();

    protected UserNotice(DisplayText text, NoticeReference noticeRef) {
        this.explicitText = text;
        this.noticeRef = noticeRef;
    }

    public String getData() throws InvalidBERException {
        StringWriter sw = new StringWriter();
        if (this.explicitText != null) {
            sw.write("Notice text :" + this.explicitText.getData());
        }
        if (this.noticeRef != null) {
            sw.write("Refernce text :" + this.noticeRef.getData());
        }
        return sw.toString();
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement((ASN1Value)this.noticeRef);
        seq.addElement((ASN1Value)this.explicitText);
        seq.encode(implicit, ostream);
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return TEMPLATE;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addOptionalElement((ASN1Template)NoticeReference.getTemplate());
            this.seqt.addOptionalElement((ASN1Template)DisplayText.getTemplate());
        }

        public boolean tagMatch(Tag t) {
            return TAG.equals((Object)t);
        }

        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicit, istream);
            return new UserNotice((DisplayText)seq.elementAt(1), (NoticeReference)seq.elementAt(0));
        }
    }
}

