/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Certification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import th.co.oga.security.pki.Certification.CertChain;
import th.co.oga.security.pki.Certification.CertChainException;
import th.co.oga.security.pki.Certification.CertPackage;
import th.co.oga.security.pki.Certification.CertPackageEncodingFormat;
import th.co.oga.security.pki.Certification.CertPackageEncodingFormatNotSupportException;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertPackageRecord;
import th.co.oga.security.pki.Certification.CertPackageType;
import th.co.oga.security.pki.Certification.PFXProfileException;
import th.co.oga.security.pki.Operation.PFXOperation;
import th.co.oga.security.pki.PinCode;
import th.co.oga.security.pki.Utils;

public class PFXProfile
implements CertPackage {
    private CertPackageType type = CertPackageType.P12;
    private PinCode pfxPassword;
    private PFXOperation devMgr;
    private Iterator contents;

    public PFXProfile(PFXOperation device, PinCode pin) {
        this.devMgr = device;
        this.pfxPassword = pin;
    }

    public PFXProfile(PFXOperation device) {
        this.devMgr = device;
        this.pfxPassword = null;
    }

    public void setPin(PinCode pin) {
        this.pfxPassword = pin;
    }

    public PFXProfile(PFXOperation device, File inputFile, PinCode pin) throws NoSuchProviderException, KeyStoreException, IOException, CertificateException, CertPackageException {
        this(device, pin);
        FileInputStream in = new FileInputStream(inputFile);
        this.fromInputStream(in, CertPackageEncodingFormat.BER);
        in.close();
    }

    public void importFromFile(File importFile, List pass) throws FileNotFoundException, CertPackageEncodingFormatNotSupportException, IOException, CertPackageException {
        if (pass.size() > 0) {
            this.setPin((PinCode)pass.get(0));
        }
        CertPackageEncodingFormat format = CertPackageEncodingFormat.getInstance(Utils.getExtension(importFile));
        FileInputStream in = new FileInputStream(importFile);
        this.fromInputStream(in, format);
        in.close();
    }

    public void importFromStream(byte[] stream, CertPackageEncodingFormat format) throws CertPackageException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(stream);
        this.fromInputStream(in, format);
        in.close();
    }

    private void fromInputStream(InputStream in, CertPackageEncodingFormat format) throws CertPackageException {
        try {
            this.devMgr.load(in, this.pfxPassword);
        }
        catch (Exception e) {
            throw new PFXProfileException(String.valueOf(this.devMgr.getName()) + " error while load PFX file, " + e.getMessage());
        }
    }

    public byte[] getBytes() throws CertPackageException {
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            this.devMgr.store(this.pfxPassword, bao);
            return bao.toByteArray();
        }
        catch (Exception e) {
            throw new PFXProfileException(e.getMessage());
        }
    }

    public X509Certificate[] getX509Certs() {
        try {
            ArrayList<X509Certificate> cerList = new ArrayList<X509Certificate>();
            Iterator itt = this.getContent();
            while (itt.hasNext()) {
                CertPackageRecord cpr = (CertPackageRecord)itt.next();
                if (!cpr.recordOf(CertPackageRecord.CertificateRec)) continue;
                cerList.add((X509Certificate)cpr.get(1));
            }
            if (cerList.size() > 0) {
                X509Certificate[] xcers = new X509Certificate[cerList.size()];
                int i = 0;
                while (i < cerList.size()) {
                    xcers[i] = (X509Certificate)cerList.get(i);
                    ++i;
                }
                return xcers;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFriendlyName() throws CertChainException {
        String rtn = null;
        return rtn;
    }

    public Iterator getContent() throws CertPackageException {
        try {
            return this.devMgr.read(this.pfxPassword);
        }
        catch (Exception e) {
            throw new CertPackageException("PFXProfile ", "Get contents \r\n" + e.toString());
        }
    }

    public CertPackageType getType() {
        return this.type;
    }

    public int getCertNumber() {
        int certCnt = 0;
        return certCnt;
    }

    public String toString() {
        return "There are elements inned";
    }

    public void addKeyEntry(PrivateKey priv, CertChain chain) throws PFXProfileException {
        if (priv.getEncoded() == null) {
            throw new PFXProfileException("Private key is unexportable ...");
        }
        try {
            this.devMgr.write(priv, chain.getX509Certs(), this.pfxPassword);
        }
        catch (Exception e) {
            throw new PFXProfileException("Adding the key entry fail, " + e.toString());
        }
    }

    public void addKeyEntry(PrivateKey priv, X509Certificate[] cers) throws PFXProfileException {
        if (priv.getEncoded() == null) {
            throw new PFXProfileException("Private key is unexportable ...");
        }
        try {
            this.devMgr.write(priv, cers, this.pfxPassword);
        }
        catch (Exception e) {
            throw new PFXProfileException("Adding the Private Key Info " + e.toString());
        }
    }

    public void export(PinCode pin, OutputStream out) throws PFXProfileException {
        try {
            this.devMgr.store(pin, out);
        }
        catch (Exception e) {
            throw new PFXProfileException("PFX Export fail, " + e.toString());
        }
    }
}

