/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Engine;

public class HSMDriver {
    public static String SAFESIGN_WIN32_LIBFILE = "aetpkss1.dll";
    public static String SAFESIGN_MODULE_NAME = "TOT-SmartCard";
    public static HSMDriver SAFESIGN_DRIVER = new HSMDriver(SAFESIGN_MODULE_NAME, SAFESIGN_WIN32_LIBFILE, null);
    public static String AUTHENEX_WIN32_LIBFILE = "_apkcs11.dll";
    public static String AUTHENEX_MODULE_NAME = "TOT-USB";
    public static HSMDriver AUTHENEX_DRIVER = new HSMDriver(AUTHENEX_MODULE_NAME, AUTHENEX_WIN32_LIBFILE, null, null, true);
    public static String THALES_MODULE_NAME = "WebSentry";
    public static String THALES_WIN32_LIBFILE = "wspkcs11d.dll";
    public static String THALES_UX_LIBFILE = "wspkcs11d.so";
    public static HSMDriver THALES_DRIVER = new HSMDriver(THALES_MODULE_NAME, THALES_WIN32_LIBFILE, THALES_UX_LIBFILE, "cryptoga ");
    public static String SUNCRYPTO_MODULE_NAME = "SUN Crypto";
    public static String SUNCRYPTO_UX_LIBFILE = "libpkcs11.so";
    public static HSMDriver SUNCRYPTO_DRIVER = new HSMDriver(SUNCRYPTO_MODULE_NAME, null, SUNCRYPTO_UX_LIBFILE);
    public static HSMDriver[] drivers = new HSMDriver[]{SAFESIGN_DRIVER, AUTHENEX_DRIVER, THALES_DRIVER, SUNCRYPTO_DRIVER};
    private String name;
    private String uxLibName;
    private String winLibName;
    private String user;
    private boolean autocheck = false;

    public HSMDriver() {
    }

    HSMDriver(String name, String winLibName, String uxLibName) {
        this(name, winLibName, uxLibName, null);
    }

    HSMDriver(String name, String winLibName, String uxLibName, String user) {
        this(name, winLibName, uxLibName, null, false);
    }

    HSMDriver(String name, String winLibName, String uxLibName, String user, boolean ac) {
        this();
        this.user = user;
        this.name = name;
        this.uxLibName = uxLibName;
        this.winLibName = winLibName;
        this.autocheck = ac;
    }

    public HSMDriver[] getDrivers() {
        return drivers;
    }

    public static HSMDriver getInstance(String name) {
        HSMDriver driver = null;
        int i = 0;
        while (i < drivers.length) {
            if (drivers[i].getModuleName().equalsIgnoreCase(name)) {
                driver = drivers[i];
                break;
            }
            ++i;
        }
        return driver;
    }

    public boolean isAutocheck() {
        return this.autocheck;
    }

    public boolean getUnixSupport() {
        return this.uxLibName != null;
    }

    public String getUXLibName() {
        return this.uxLibName;
    }

    public String getWinLibName() {
        return this.winLibName;
    }

    public String getModuleName() {
        return this.name;
    }

    public boolean getWinSupport() {
        return this.winLibName != null;
    }

    public char[] getPin(char[] supplyPin) {
        if (this.user != null) {
            String pin = String.valueOf(this.user) + new String(supplyPin);
            return pin.toCharArray();
        }
        return supplyPin;
    }
}

