/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Engine;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.Engine.SecureModule;
import th.co.oga.security.pki.Engine.SecureProviderException;
import th.co.oga.security.pki.Engine.SecureProviderName;
import th.co.oga.security.pki.Engine.SecureProviderType;
import th.co.oga.security.pki.Engine.SecureProviderTypeNotSupportException;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.xml.XMLNodeConversionException;
import th.co.oga.security.xml.XMLRecord;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class SecureEngine
extends ArrayList
implements XMLRecord {
    private List idx = SecureProviderType.getList();

    private SecureEngine() {
        int i = 0;
        while (i < this.idx.size()) {
            if (this.size() < this.idx.size()) {
                this.add(null);
            }
            ++i;
        }
    }

    public SecureEngine(Provider provider) {
        this();
        this.setProvider(provider);
    }

    public void setProvider(Provider provider) {
        int i = 0;
        while (i < this.idx.size()) {
            try {
                this.addModule((SecureProviderType)this.idx.get(i), provider);
            }
            catch (SecureProviderTypeNotSupportException secureProviderTypeNotSupportException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void setProvider(SecureProviderType type, Provider provider) throws SecureProviderTypeNotSupportException {
        this.addModule(type, provider);
    }

    public void addModule(SecureProviderType type, Provider provider) throws SecureProviderTypeNotSupportException {
        this.addModule(SecureProviderName.getInstance(provider.getName()).getSecureModule(type));
    }

    public void addModule(SecureModule module) throws SecureProviderTypeNotSupportException {
        int pointer = this.idx.indexOf(module.getType());
        if (pointer <= -1) {
            throw new SecureProviderTypeNotSupportException(module.getName());
        }
        this.remove(pointer);
        this.add(pointer, module);
    }

    public SecureEngine(Node node) throws XMLRecordDataException {
        this();
        this.setXMLRecord(node);
    }

    public Provider getProvider(SecureProviderType pType) {
        return ((SecureModule)this.get(this.idx.indexOf(pType))).getProvider();
    }

    public SecureModule getSecureModule(SecureProviderType pType) {
        return (SecureModule)this.get(this.idx.indexOf(pType));
    }

    public static void installAllProvider() throws SecureProviderException {
        List prds = SecureProviderName.getList();
        int i = 0;
        while (i < prds.size()) {
            SecureProviderName prdName = (SecureProviderName)prds.get(i);
            if (!SecureProviderName.findProviderName(prdName.getName()) && prdName.isSupportOS()) {
                Security.insertProviderAt(prdName.getProviderInstance(), 1);
            }
            ++i;
        }
    }

    public void setXMLRecord(Node node) throws XMLRecordDataException {
        NodeList nodeList = node.getChildNodes();
        try {
            int i = 0;
            while (i < nodeList.getLength()) {
                if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                    String nv = Utils.nodeValue(nodeList.item(i));
                    String nn = Utils.nodeName(nodeList.item(i));
                    this.addModule(new SecureModule(nodeList.item(i)));
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new XMLRecordDataException("SecureEngine", e.toString());
        }
    }

    public Node getXMLNode(Document doc) throws XMLNodeConversionException {
        Element node = doc.createElement(CryptOGAFormat.SEC_ENGINE);
        try {
            int i = 0;
            while (i < this.idx.size()) {
                node.appendChild(((SecureModule)this.get(i)).getXMLNode(doc));
                ++i;
            }
        }
        catch (Exception e) {
            throw new XMLNodeConversionException(this.toString(), CryptOGAFormat.SEC_ENGINE, e.toString());
        }
        return node;
    }

    public String getParentElementName() {
        return CryptOGAFormat.SEC_ENGIN_PARENT;
    }

    public String getElementName() {
        return CryptOGAFormat.SEC_ENGINE;
    }

    public boolean isXMLNode(Node node) throws XMLRecordDataException {
        SecureEngine se = new SecureEngine(node);
        return this.hashCode() == se.hashCode();
    }

    public String toString() {
        return null;
    }
}

