/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Engine;

import java.security.Provider;
import java.util.Iterator;
import java.util.jar.Attributes;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.Engine.SecureProviderName;
import th.co.oga.security.pki.Engine.SecureProviderType;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.xml.XMLNodeConversionException;
import th.co.oga.security.xml.XMLRecord;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class SecureModule
extends Attributes
implements XMLRecord {
    private SecureProviderType type;
    private Provider provider = null;
    public static final String STORE_BASE = "StoreBase";

    private SecureModule() {
    }

    protected void setProvider(Provider provider) {
        this.provider = provider;
        this.addParameters(STORE_BASE, SecureProviderName.getInstance(provider.getName()).getStoreName());
    }

    protected void setType(SecureProviderType type) {
        this.type = type;
    }

    public SecureModule(SecureProviderType type, Provider provider) {
        this();
        this.setType(type);
        this.setProvider(provider);
    }

    public SecureModule(Node node) throws XMLRecordDataException {
        this();
        this.setXMLRecord(node);
    }

    public void addParameters(String key, String value) {
        if (this.containsKey(key)) {
            this.remove(key);
        }
        this.putValue(key, value);
    }

    public void addParameters(String key) {
        this.addParameters(key, null);
    }

    public boolean is(SecureModule type) {
        return type.getName().equalsIgnoreCase(type.getName());
    }

    public String getName() {
        return this.type.getName();
    }

    public SecureProviderType getType() {
        return this.type;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getIDentifier() {
        String id = "Provider=" + this.provider.getName();
        if (this.size() > 0) {
            Iterator<Object> itr = this.keySet().iterator();
            while (itr.hasNext()) {
                String key = itr.next().toString();
                id = String.valueOf(id) + ", " + key + "=" + this.getValue(key);
            }
        }
        return id;
    }

    public String getElementName() {
        return CryptOGAFormat.SEC_MODULE;
    }

    public String getParentElementName() {
        return CryptOGAFormat.SEC_MODULE_PARENT;
    }

    public Node getXMLNode(Document doc) throws XMLNodeConversionException {
        Element parent = doc.createElement(CryptOGAFormat.SEC_MODULE);
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.SEC_MODULE_TYPE, this.getName()));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.SEC_MODULE_PROVIDER, this.getProvider().getName()));
        if (this.size() > 0) {
            Iterator<Object> itr = this.keySet().iterator();
            while (itr.hasNext()) {
                String key = itr.next().toString();
                String value = this.getValue(key);
                parent.appendChild(XMLUtils.createElementNode(doc, key, value));
            }
        }
        return parent;
    }

    public boolean isXMLNode(Node node) throws XMLRecordDataException {
        SecureModule sd = new SecureModule(node);
        return this.hashCode() == sd.hashCode();
    }

    public void setXMLRecord(Node node) throws XMLRecordDataException {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() <= 0) {
            throw new XMLRecordDataException("SecureModule", " Empty node was supplied " + node.toString());
        }
        try {
            int i = 0;
            while (i < nodeList.getLength()) {
                if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                    String nv = Utils.nodeValue(nodeList.item(i));
                    String nn = Utils.nodeName(nodeList.item(i));
                    if (nn.equalsIgnoreCase(CryptOGAFormat.SEC_MODULE_TYPE)) {
                        this.setType(SecureProviderType.getInstance(nv));
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.SEC_MODULE_PROVIDER)) {
                        this.setProvider(SecureProviderName.getInstance(nv).getProviderInstance());
                    } else {
                        this.addParameters(nn, nv);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new XMLRecordDataException("SecureModule", e.toString());
        }
    }
}

