/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Engine;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import th.co.oga.security.pki.Engine.JSDPSecureModule;
import th.co.oga.security.pki.Engine.SecureModule;
import th.co.oga.security.pki.Engine.SecureProviderType;
import th.co.oga.security.pki.HouseKeeping.SaveHouse;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSTokenOperator;
import th.co.oga.security.pki.Operator.TokenOperator;
import th.co.oga.security.pki.Operator.WSJSDP.JSDPTokenOperator;

public class SecureProviderName {
    private String name = "";
    private String code = "";
    private String supportOS = "UNIX, WINDOWS";
    public static SecureProviderName AJCEP = new SecureProviderName("AJCEP", "AJCEP", "WINDOWS");
    public static SecureProviderName MOZILLA_JSS = new SecureProviderName("Mozilla-JSS", "JSS");
    public static SecureProviderName JSDP = new SecureProviderName("JSDP", "JSDP");
    public static SecureProviderName SUN = new SecureProviderName("SUN", "JKS");
    public static SecureProviderName SUN_JCE = new SecureProviderName("SunJCE", "EJKS");
    public static SecureProviderName SUN_JSS = new SecureProviderName("SunJSSE", "EJKS");
    public static SecureProviderName DEFAULT = SUN;

    protected SecureProviderName(String name, String code, String supportOS) {
        this.name = name;
        this.code = code;
        this.supportOS = supportOS;
    }

    protected SecureProviderName(String name, String code) {
        this(name, code, "UNIX, WINDOWS");
    }

    public static SecureProviderName getInstance(String pname) {
        if ("MOZILLA-JSS,JSS,MOZILLA".indexOf(pname.toUpperCase()) > -1) {
            return MOZILLA_JSS;
        }
        if ("MSPROVIDER, ASSAMBLA, AJCEP".indexOf(pname.toUpperCase()) > -1) {
            return AJCEP;
        }
        if ("WS-JSDP,WEBSENTRY,JSDP".indexOf(pname.toUpperCase()) > -1) {
            return JSDP;
        }
        if ("SUN".equalsIgnoreCase(pname)) {
            return SUN;
        }
        if ("SUNJCE,JCE".indexOf(pname.toUpperCase()) > -1) {
            return SUN_JCE;
        }
        if ("SUNJSSE,JSSE".indexOf(pname.toUpperCase()) > -1) {
            return SUN_JSS;
        }
        return DEFAULT;
    }

    public SecureModule getSecureModule(SecureProviderType type) {
        if ("WS-JSDP,WEBSENTRY,JSDP".indexOf(this.name.toUpperCase()) > -1) {
            return new JSDPSecureModule(type, this.getProviderInstance());
        }
        return new SecureModule(type, this.getProviderInstance());
    }

    public static boolean findProviderName(String name) {
        Provider[] providers = Security.getProviders();
        boolean found = false;
        int i = 0;
        while (i < providers.length) {
            if (name.equalsIgnoreCase(providers[i].getName())) {
                found = true;
                break;
            }
            ++i;
        }
        return found;
    }

    public boolean is(SecureProviderName name) {
        return this.getName().equalsIgnoreCase(name.getName());
    }

    public boolean is(Provider provider) {
        return this.getName().equalsIgnoreCase(provider.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getStoreName() {
        return this.code;
    }

    public Provider getProviderInstance() {
        try {
            if (this.is(MOZILLA_JSS)) {
                return (Provider)Class.forName("org.mozilla.jss.JSSProvider").newInstance();
            }
            if (this.is(JSDP)) {
                return (Provider)Class.forName("com.entegrity.jsdp.security.provider.JSDP").newInstance();
            }
            if (this.is(AJCEP)) {
                return (Provider)Class.forName("se.assembla.jce.provider.ms.MSProvider").newInstance();
            }
            if (SecureProviderName.findProviderName(this.name)) {
                return Security.getProvider(this.name);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("System error:can not create JCE Secure Provider," + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("System error:can not create JCE Secure Provider," + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("System error:can not create JCE Secure Provider," + e.getMessage());
        }
        return null;
    }

    public static String[] getAllName() {
        String providers = "";
        providers = SecureProviderName.addProvName(providers, MOZILLA_JSS);
        providers = SecureProviderName.addProvName(providers, JSDP);
        if ((providers = SecureProviderName.addProvName(providers, AJCEP)).length() > 0) {
            return providers.split(", ");
        }
        return null;
    }

    private static String addProvName(String names, SecureProviderName prov) {
        if (prov.isSupportOS()) {
            String sepp = names.length() > 0 ? ", " : "";
            names = String.valueOf(names) + sepp + prov.getName();
        }
        return names;
    }

    public boolean isSupportOS() {
        String os = "";
        os = SaveHouse.isWin32() ? "WINDOWS" : "UNIX";
        return this.supportOS.indexOf(os) > -1;
    }

    public static List getList() {
        ArrayList<SecureProviderName> list = new ArrayList<SecureProviderName>();
        list.add(SUN);
        list.add(SUN_JCE);
        list.add(SUN_JSS);
        list.add(MOZILLA_JSS);
        list.add(JSDP);
        list.add(AJCEP);
        return list;
    }

    public static TokenOperator getTokenOperator(SecureModule module) {
        Provider provider = module.getProvider();
        if (MOZILLA_JSS.is(provider)) {
            return new JSSTokenOperator(module);
        }
        if (JSDP.is(provider)) {
            return new JSDPTokenOperator(module);
        }
        return null;
    }
}

