/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Engine;

import java.util.ArrayList;
import java.util.List;

public class SecureProviderType {
    private String name = "";
    public static String DEFAULT_MANAGER = "DEFAULT";
    public static String KEY_MANAGER = "KeyManager";
    public static String CERT_MANAGER = "CertificateManager";
    public static String STORE_MANAGER = "StorageManager";
    public static String CRYPTO_MANAGER = "CryptoGraphicsManager";
    public static String TRANSPORT_MANAGER = "TransportManager";
    public static SecureProviderType DEFAULT = new SecureProviderType(DEFAULT_MANAGER);
    public static SecureProviderType KEY = new SecureProviderType(KEY_MANAGER);
    public static SecureProviderType CERT = new SecureProviderType(CERT_MANAGER);
    public static SecureProviderType STORE = new SecureProviderType(STORE_MANAGER);
    public static SecureProviderType CRYPTO = new SecureProviderType(CRYPTO_MANAGER);
    public static SecureProviderType TRANSPORT = new SecureProviderType(TRANSPORT_MANAGER);

    protected SecureProviderType(String cname) {
        this.name = cname;
    }

    public static SecureProviderType getInstance(String pname) {
        if (KEY_MANAGER.equalsIgnoreCase(pname)) {
            return KEY;
        }
        if (CERT_MANAGER.equalsIgnoreCase(pname)) {
            return CERT;
        }
        if (STORE_MANAGER.equalsIgnoreCase(pname)) {
            return STORE;
        }
        if (CRYPTO_MANAGER.equalsIgnoreCase(pname)) {
            return CRYPTO;
        }
        if (TRANSPORT_MANAGER.equalsIgnoreCase(pname)) {
            return TRANSPORT;
        }
        return DEFAULT;
    }

    public boolean is(SecureProviderType type) {
        return this.getName().equalsIgnoreCase(type.getName());
    }

    public String getName() {
        return this.name;
    }

    public static String[] getAllTypeName() {
        return new String[]{KEY.getName(), CERT.getName(), STORE.getName(), CRYPTO.getName()};
    }

    public static List getList() {
        ArrayList<SecureProviderType> list = new ArrayList<SecureProviderType>();
        list.add(STORE);
        list.add(CRYPTO);
        list.add(TRANSPORT);
        list.add(DEFAULT);
        return list;
    }
}

