/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.HouseKeeping;

import java.io.CharConversionException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.Engine.SecureEngine;
import th.co.oga.security.pki.HouseKeeping.AgentProfileVerifyException;
import th.co.oga.security.pki.NameValueInvalidException;
import th.co.oga.security.pki.Operator.MozillaJSS.JSSKeyPairAlgo;
import th.co.oga.security.pki.Reference;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.pki.X500.DName;
import th.co.oga.security.utils.SysEnv;
import th.co.oga.security.xml.XMLNodeConversionException;
import th.co.oga.security.xml.XMLRecord;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class AgentProfile
implements XMLRecord {
    protected String id;
    protected String name;
    protected String agentType = "";
    protected JSSKeyPairAlgo keyType = JSSKeyPairAlgo.RSA;
    protected String signature;
    protected DName dName = new DName();
    protected SecureEngine engine = new SecureEngine(Utils.getJSSProvider());
    protected int keyPairSize = 512;
    protected String keyPairAlgo = "NA";
    protected String signatureAlgo = "NA";
    protected String encryptionAlgo = "NA";
    protected String keyWrappingAlgo = "NA";
    protected String defaultCert = "NA";
    private boolean initialed = true;
    public static int LOW_LEVEL_VERIFY = 0;
    public static int MIDLE_LEVEL_VERIFY = 1;
    public static int HEIGHT_LEVEL_VERIFY = 9;

    public AgentProfile() {
    }

    public AgentProfile(String id, String name, String agentType, JSSKeyPairAlgo keyType) throws AgentProfileVerifyException {
        this.id = id;
        this.name = name;
        this.agentType = agentType;
        this.keyType = keyType;
        this.signature = id;
        this.initialed = false;
    }

    public static AgentProfile getMyProfile() throws AgentProfileVerifyException {
        return new AgentProfile(SysEnv.userName, SysEnv.userName);
    }

    public AgentProfile(String id, String name) throws AgentProfileVerifyException {
        this(id, name, SysEnv.userName.equalsIgnoreCase(id) ? Reference.AGENT_TYPE_STAFF : Reference.AGENT_TYPE_VISITOR, JSSKeyPairAlgo.RSA);
    }

    public AgentProfile(Node node) throws XMLRecordDataException, AgentProfileVerifyException {
        this.setXMLRecord(node);
        this.verify(MIDLE_LEVEL_VERIFY);
    }

    public void setSubjectName(DName dName) throws CharConversionException {
        this.dName = dName;
    }

    public DName getSubjectName() {
        return this.dName;
    }

    public DName getDName() {
        return this.dName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAgentType() {
        return this.agentType;
    }

    public JSSKeyPairAlgo getKeyType() {
        return this.keyType;
    }

    public SecureEngine getEngine() {
        return this.engine;
    }

    public void setEngine(SecureEngine sEngine) {
        this.engine = sEngine;
    }

    public String getKeyWrapAlgo() {
        return this.keyWrappingAlgo;
    }

    public String getEncryptionAlgo() {
        return this.encryptionAlgo;
    }

    public String getSignatureAlgo() {
        return this.signatureAlgo;
    }

    public String getKeyPairAlgo() {
        return this.keyPairAlgo;
    }

    public int getKeyPairSize() {
        return this.keyPairSize;
    }

    public CertProfile getDefaultCertificate() throws IOException, CertProfileException, CertificateException {
        if (this.defaultCert.equalsIgnoreCase("NA")) {
            return null;
        }
        return CertProfile.getInstance(Utils.getBytesFromBase64(this.defaultCert));
    }

    public void setKeyWrapAlgo(String oid) {
        this.keyWrappingAlgo = oid;
    }

    public void setEncryptionAlgo(String oid) {
        this.encryptionAlgo = oid;
    }

    public void setSignatureAlgo(String oid) {
        this.signatureAlgo = oid;
    }

    public void setKeyPairAlgo(String oid) {
        this.keyPairAlgo = oid;
    }

    public void setKeyPairSize(int size) {
        this.keyPairSize = size;
    }

    public void setDefaultCertificate(CertProfile cert) throws IOException, CertPackageException {
        this.defaultCert = Utils.getBase64FromDER(cert.getBytes());
    }

    public void setXMLRecord(Node node) throws XMLRecordDataException {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() <= 0) {
            throw new XMLRecordDataException("AgentProfile", " Empty node was supplied " + node.toString());
        }
        try {
            int i = 0;
            while (i < nodeList.getLength()) {
                if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                    String nv = Utils.nodeValue(nodeList.item(i));
                    String nn = Utils.nodeName(nodeList.item(i));
                    if (nn.equalsIgnoreCase(CryptOGAFormat.PROFILE_ID)) {
                        this.id = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.PROFILE_NAME)) {
                        this.name = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.PROFILE_AGENT_TYPE)) {
                        this.agentType = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.PROFILE_KEY_TYPE)) {
                        this.keyType = JSSKeyPairAlgo.getInstance(nv);
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.PROFILE_KEY_PAIR_ALGO)) {
                        this.keyPairAlgo = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.PROFILE_KEY_PAIR_SIZE)) {
                        this.keyPairSize = new BigInteger(nv).intValue();
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.PROFILE_SIGNATURE_ALGO)) {
                        this.signatureAlgo = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.PROFILE_ENCRYPTION_ALGO)) {
                        this.encryptionAlgo = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.PROFILE_KEYWRAPPING_ALGO)) {
                        this.keyWrappingAlgo = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.PROFILE_DEFULT_CERT)) {
                        this.defaultCert = nv;
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.PROFILE_DNAME)) {
                        this.dName.setXMLRecord(nodeList.item(i));
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.PROFILE_ENGINE)) {
                        this.engine.setXMLRecord(nodeList.item(i));
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new XMLRecordDataException("AgentProfile", e.toString());
        }
    }

    public void verify() throws AgentProfileVerifyException {
        this.verify(0);
    }

    public void verify(int level) throws AgentProfileVerifyException {
        boolean verified = false;
        try {
            if (level <= LOW_LEVEL_VERIFY && this.agentType.length() == 0) {
                throw new AgentProfileVerifyException("Level " + LOW_LEVEL_VERIFY + " Room Type Name ", this.agentType);
            }
            if (verified && level <= MIDLE_LEVEL_VERIFY && !this.dName.verify()) {
                throw new AgentProfileVerifyException("Level " + MIDLE_LEVEL_VERIFY + " Subject Name ", this.dName.toString());
            }
            if (verified && level <= HEIGHT_LEVEL_VERIFY && (this.id.length() == 0 || this.name.length() == 0)) {
                throw new AgentProfileVerifyException("Level " + HEIGHT_LEVEL_VERIFY + " Base Properties ", " ID:" + this.id + " , NAME:" + this.name);
            }
        }
        catch (NullPointerException e) {
            throw new AgentProfileVerifyException(" Level -1 under all levels ", e.toString());
        }
    }

    public void setStoreBase(String path) {
        this.agentType = path;
    }

    public void setNameValue(OBJECT_IDENTIFIER oid, String str) throws NameValueInvalidException {
        if (str.length() > 0) {
            this.dName.addValue(oid, str);
        }
    }

    public String getNameValue(OBJECT_IDENTIFIER oid) {
        return this.dName.getValue(oid);
    }

    public String getDNString() {
        return this.dName.getSubject();
    }

    public boolean is(String pid) {
        return this.id.equalsIgnoreCase(pid);
    }

    public Node getXMLNode(Document doc) throws XMLNodeConversionException {
        Element parent = doc.createElement(CryptOGAFormat.PROFILE);
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.PROFILE_ID, this.id));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.PROFILE_NAME, this.name));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.PROFILE_AGENT_TYPE, this.agentType));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.PROFILE_KEY_TYPE, this.keyType.toString()));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.PROFILE_KEY_PAIR_ALGO, this.keyPairAlgo));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.PROFILE_KEY_PAIR_SIZE, "" + this.keyPairSize));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.PROFILE_SIGNATURE_ALGO, this.signatureAlgo));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.PROFILE_ENCRYPTION_ALGO, this.encryptionAlgo));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.PROFILE_KEYWRAPPING_ALGO, this.keyWrappingAlgo));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.PROFILE_DEFULT_CERT, this.defaultCert));
        parent.appendChild(this.dName.getXMLNode(doc));
        parent.appendChild(this.engine.getXMLNode(doc));
        return parent;
    }

    public String getParentElementName() {
        return CryptOGAFormat.PROFILE_PARENT;
    }

    public String getElementName() {
        return CryptOGAFormat.PROFILE;
    }

    public boolean isXMLNode(Node node) throws XMLRecordDataException {
        boolean rtn = false;
        try {
            AgentProfile agentProfile = new AgentProfile(node);
            rtn = this.is(agentProfile.getId());
        }
        catch (AgentProfileVerifyException e) {
            throw new XMLRecordDataException("AgentProfile", e.toString());
        }
        return rtn;
    }

    public String toString() {
        return "[ ID:" + this.id + " , Name:" + this.name + " , PkiBase:" + this.agentType + " , keyType=" + this.keyType.toString() + " , " + this.dName.toString() + " ]";
    }
}

