/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.HouseKeeping;

import java.io.File;
import org.w3c.dom.NodeList;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.HouseKeeping.CRLList;
import th.co.oga.security.pki.HouseKeeping.ConfigFailException;
import th.co.oga.security.pki.HouseKeeping.ProfileAlreadyExistException;
import th.co.oga.security.pki.HouseKeeping.ProfileNotFoundException;
import th.co.oga.security.pki.x.CRL.CRLProfile;
import th.co.oga.security.utils.SysEnv;
import th.co.oga.security.xml.Explorable;
import th.co.oga.security.xml.XMLConfigEngineException;
import th.co.oga.security.xml.XMLConfigFile;
import th.co.oga.security.xml.XMLConfigFileBackupException;
import th.co.oga.security.xml.XMLConfigFileLoadException;
import th.co.oga.security.xml.XMLConfigFileManipulateException;
import th.co.oga.security.xml.XMLConfigFileNotFoundException;
import th.co.oga.security.xml.XMLConfigFilePreException;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class CRLRegister
extends XMLConfigFile
implements Explorable {
    protected String TAG_ROOT = CryptOGAFormat.CRL_REG_ROOT;
    protected String TAG_CRL_ENTRY = CryptOGAFormat.CRL_REG_ENTRY;
    private CRLList crlList = new CRLList();
    private String base = null;

    public CRLRegister(String base) throws ConfigFailException, XMLConfigFileNotFoundException, XMLConfigFileLoadException, XMLRecordDataException, XMLConfigEngineException {
        super(String.valueOf(base) + SysEnv.FS + CryptOGAFormat.CRL_REG_FILE_NAME);
        this.base = base;
        try {
            this.loadProfileList();
        }
        catch (ProfileAlreadyExistException e) {
            throw new ConfigFailException("Load all profiles ", e.getMessage());
        }
    }

    public static void initConfigFile(String base) throws ConfigFailException {
        File configFile = new File(String.valueOf(base) + SysEnv.FS + CryptOGAFormat.CRL_REG_FILE_NAME);
        if (!configFile.exists()) {
            String configText = "";
            try {
                String crlTag = "\r\n\t\t" + XMLUtils.elementTag(CryptOGAFormat.CRL_PRF_PARENT, "");
                configText = String.valueOf(configText) + "\r\n\t" + XMLUtils.elementTag(CryptOGAFormat.CRL_REG_ROOT, crlTag);
                XMLUtils.initXMLFile(configFile, configText);
            }
            catch (Exception e) {
                throw new ConfigFailException("Error while CRL Register file initialization ", e.toString());
            }
        }
    }

    public String explore() {
        String rtn = "";
        NodeList nl = super.getNodeList(CryptOGAFormat.CRL_PRF_PARENT);
        int c = 0;
        while (c < nl.getLength()) {
            rtn = String.valueOf(rtn) + XMLUtils.nodeExplorer(nl.item(c), "", 0);
            ++c;
        }
        return rtn;
    }

    public CRLList getProfileList() {
        return this.crlList;
    }

    private void apply() throws XMLConfigFileManipulateException, ConfigFailException {
        try {
            String updNo = this.beginUpdate();
            this.flushUpdate(updNo);
        }
        catch (XMLConfigFileNotFoundException e) {
            throw new XMLConfigFileManipulateException(e.toString());
        }
        catch (XMLConfigFileBackupException e) {
            throw new XMLConfigFileManipulateException(e.toString());
        }
        catch (XMLConfigEngineException e) {
            throw new XMLConfigFileManipulateException(e.toString());
        }
        catch (XMLConfigFilePreException e) {
            throw new XMLConfigFileManipulateException(e.toString());
        }
        this.reload();
    }

    public CRLList reload() throws ConfigFailException {
        try {
            this.refresh();
            this.loadProfileList();
        }
        catch (Exception e) {
            throw new ConfigFailException("Reload content ", e.toString());
        }
        return this.crlList;
    }

    private void loadProfileList() throws ProfileAlreadyExistException, ConfigFailException, XMLRecordDataException {
        NodeList parent = this.getNodeList(this.TAG_CRL_ENTRY);
        if (parent.getLength() == 0) {
            this.addEmptyElement(this.TAG_ROOT, this.TAG_CRL_ENTRY);
            parent = this.getNodeList(this.TAG_CRL_ENTRY);
            if (parent.getLength() == 0) {
                throw new ConfigFailException("Load CRL list ", " It is no element " + this.TAG_CRL_ENTRY);
            }
        }
        if (parent.getLength() > 1) {
            throw new ConfigFailException("Load CRL list ", " Too many element of " + this.TAG_CRL_ENTRY);
        }
        CRLList pList = new CRLList();
        NodeList nodeList = parent.item(0).getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                CRLProfile profile = new CRLProfile(nodeList.item(i));
                try {
                    profile.load(this.getCRLFileName(profile.getFileName()));
                }
                catch (Exception e) {
                    throw new ConfigFailException("Load CRL Profile from file fail, ", e.toString());
                }
                pList.setProfile(profile);
            }
            ++i;
        }
        this.crlList = pList;
    }

    public File getCRLFile(CRLProfile profile) {
        return new File(String.valueOf(this.base) + SysEnv.FS + profile.getFileName());
    }

    public String getCRLFileName(String fileName) {
        return String.valueOf(this.base) + SysEnv.FS + fileName;
    }

    public boolean isUpdate(CRLProfile profile) {
        CRLProfile existProfile = this.crlList.getProfile(profile.getAuthorityName());
        return existProfile == null || existProfile.isOlder(profile);
    }

    public CRLList setProfile(CRLProfile profile) throws ConfigFailException {
        try {
            profile.saveFile(this.getCRLFileName(profile.getFileName()));
            if (this.crlList.indexOf(profile) > -1) {
                this.updElement(profile);
            } else {
                this.addElement(profile);
            }
            this.apply();
        }
        catch (Exception e) {
            throw new ConfigFailException("Update CRL Entry to config file ", e.toString());
        }
        return this.crlList;
    }

    public CRLList dropProfile(CRLProfile profile) throws ConfigFailException, ProfileNotFoundException {
        if (this.crlList.indexOf(profile) < 0) {
            throw new ProfileNotFoundException(profile.getAuthorityName());
        }
        try {
            this.deleteElement(profile);
            this.apply();
        }
        catch (Exception e) {
            throw new ConfigFailException("Delete CRL Entry from register ", e.toString());
        }
        return this.crlList;
    }
}

