/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.HouseKeeping;

import java.security.PublicKey;
import java.util.ArrayList;
import th.co.oga.security.pki.Certification.CSRProfile;
import th.co.oga.security.pki.Certification.CSRProfileVerifyException;
import th.co.oga.security.pki.HouseKeeping.ProfileAlreadyExistException;
import th.co.oga.security.xml.Explorable;
import th.co.oga.security.xml.IndexList;

public class CSRList
extends ArrayList
implements Explorable {
    private IndexList idx = new IndexList();

    public void addProfile(CSRProfile profile) throws ProfileAlreadyExistException, CSRProfileVerifyException {
        profile.verify();
        if (this.idx.recNo(profile.getSN()) != -1) {
            throw new ProfileAlreadyExistException(profile.getSN());
        }
        this.add(profile);
        this.idx.addKey(profile.getSN());
    }

    public CSRProfile getCSR(PublicKey key) {
        CSRProfile csr = null;
        int i = 0;
        while (i < this.size()) {
            CSRProfile a = (CSRProfile)this.get(i);
            if (a.is(key)) {
                csr = a;
                break;
            }
            ++i;
        }
        return csr;
    }

    public CSRProfile getProfile(String sn) {
        return (CSRProfile)this.get(this.idx.recNo(sn));
    }

    public int indexOf(CSRProfile profile) {
        return this.idx.recNo(profile.getSN());
    }

    public String explore() {
        String rtn = "";
        String key = "";
        int i = 0;
        while (i < this.size()) {
            key = (String)this.idx.get(i);
            CSRProfile a = (CSRProfile)this.get(i);
            rtn = String.valueOf(rtn) + "[ " + i + " | " + key + " ]" + a.toString() + "\n";
            ++i;
        }
        return rtn;
    }
}

