/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.HouseKeeping;

import java.util.ArrayList;
import java.util.Collection;
import th.co.oga.security.pki.HouseKeeping.CertStoreProfile;
import th.co.oga.security.pki.Operation.CertStoreOperation;
import th.co.oga.security.pki.Operation.CertStoreStartFailException;
import th.co.oga.security.pki.Operation.CertStoreStopFailException;

public class CertStoreList
extends ArrayList {
    protected CertStoreList(int initialCapacity) {
        super(initialCapacity);
    }

    protected CertStoreList(Collection c) {
        super(c);
    }

    public CertStoreList() {
    }

    public int indexOf(CertStoreProfile csp) {
        int p = -1;
        int i = 0;
        while (i < this.size()) {
            if (((CertStoreProfile)this.get(i)).is(csp)) {
                p = i;
                break;
            }
            ++i;
        }
        return p;
    }

    public void addCertStore(CertStoreOperation cso) {
        boolean found = false;
        int i = 0;
        while (i < this.size()) {
            if (((CertStoreProfile)this.get(i)).getCertStoreProviderNumber() == cso.getOperatorNumber()) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            this.add(new CertStoreProfile(cso));
        }
    }

    public void setCertStoreProfile(CertStoreProfile csp) {
        CertStoreProfile csp1 = null;
        int i = 0;
        while (i < this.size()) {
            if (((CertStoreProfile)this.get(i)).is(csp)) {
                csp1 = (CertStoreProfile)this.get(i);
                break;
            }
            ++i;
        }
        if (csp1 == null) {
            this.add(csp);
        } else {
            csp1.setUpdate(csp);
        }
    }

    public void startCertStore() throws CertStoreStartFailException {
        int i = 0;
        while (i < this.size()) {
            CertStoreProfile csp = (CertStoreProfile)this.get(i);
            if (csp.isEnabled()) {
                csp.start();
            }
            ++i;
        }
    }

    public void stopCertStore() throws CertStoreStopFailException {
        String error = "";
        int i = 0;
        while (i < this.size()) {
            CertStoreProfile csp = (CertStoreProfile)this.get(i);
            if (csp.isEnabled()) {
                try {
                    csp.stop();
                }
                catch (CertStoreStopFailException e) {
                    error = "\n" + e.getMessage();
                }
            }
            ++i;
        }
        if (error != null) {
            throw new CertStoreStopFailException("CertStoreList", "! Some cert store cannot stop as following:" + error);
        }
    }
}

