/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.HouseKeeping;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.HouseKeeping.CertStoreParams;
import th.co.oga.security.pki.Operation.CertStoreConstructionFailException;
import th.co.oga.security.pki.Operation.CertStoreOperation;
import th.co.oga.security.pki.Operation.CertStoreStartFailException;
import th.co.oga.security.pki.Operation.CertStoreStopFailException;
import th.co.oga.security.pki.Operator.Assembla.AJCE_CertStore;
import th.co.oga.security.pki.Operator.DBCertStore;
import th.co.oga.security.pki.Utils;
import th.co.oga.security.xml.XMLNodeConversionException;
import th.co.oga.security.xml.XMLRecord;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class CertStoreProfile
implements XMLRecord {
    public static int STATE_ENABLE = 0;
    public static int STATE_DISABLE = 1;
    private boolean registered = false;
    private CertStoreOperation certStore;
    private int state = STATE_DISABLE;
    private CertStoreParams params;

    public CertStoreProfile(Node node) throws XMLRecordDataException {
        this.setXMLRecord(node);
        this.registered = true;
    }

    public CertStoreProfile(CertStoreOperation cs) {
        this.certStore = cs;
        this.params = cs.getParameters();
    }

    public CertStoreProfile(CertStoreOperation cs, boolean enabled) {
        this(cs);
        this.setEnabled(enabled);
    }

    public int getCertStoreProviderNumber() {
        return this.certStore.getOperatorNumber();
    }

    public boolean is(CertStoreOperation cs) {
        return this.certStore.getOperatorNumber() == cs.getOperatorNumber();
    }

    public boolean is(CertStoreProfile csp) {
        return this.certStore.getOperatorNumber() == csp.getCertStoreProviderNumber();
    }

    public void setEnabled(boolean enabled) {
        this.state = enabled ? 0 : 1;
    }

    public boolean isEnabled() {
        return this.state == 0;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setUpdate(CertStoreProfile csp) {
        this.certStore = csp.certStore;
        this.state = csp.state;
        this.params = csp.params;
    }

    public void setParams(CertStoreParams params) {
        this.params = params;
    }

    public CertStoreParams getParams() {
        return this.params;
    }

    public CertStoreOperation getCertStore() throws CertStoreStartFailException {
        if (!this.certStore.isStart()) {
            this.certStore.start(this.params);
        }
        return this.certStore;
    }

    public String getName() {
        if (CertStoreOperation.CERTSTORE_NAMES.length > this.certStore.getOperatorNumber()) {
            return CertStoreOperation.CERTSTORE_NAMES[this.certStore.getOperatorNumber()];
        }
        return "Undefined";
    }

    public static CertStoreOperation getCSOInstance(int certStoreOperatorNumber) throws CertStoreConstructionFailException {
        if (certStoreOperatorNumber == 2) {
            return new DBCertStore();
        }
        if (certStoreOperatorNumber == 1) {
            return AJCE_CertStore.getInstance();
        }
        throw new CertStoreConstructionFailException("Unknow", "The specify cert store operator number is not in list.");
    }

    public static CertStoreProfile getInstance(int certStoreOperatorNumber) throws CertStoreConstructionFailException {
        if (certStoreOperatorNumber == 2) {
            return new CertStoreProfile(new DBCertStore());
        }
        if (certStoreOperatorNumber == 1) {
            return new CertStoreProfile(AJCE_CertStore.getInstance());
        }
        throw new CertStoreConstructionFailException("Unknow", "The specify cert store operator number is not in list.");
    }

    public static CertStoreProfile getInstance(int certStoreOperatorNumber, int enable, CertStoreParams params) throws CertStoreConstructionFailException {
        CertStoreProfile csp = CertStoreProfile.getInstance(certStoreOperatorNumber);
        csp.state = enable;
        csp.params = params;
        return csp;
    }

    public Node getXMLNode(Document doc) throws XMLNodeConversionException {
        Element parent = doc.createElement(this.getElementName());
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CERT_STORE_OPERATOR_NUMBER, "" + this.getCertStoreProviderNumber()));
        parent.appendChild(XMLUtils.createElementNode(doc, CryptOGAFormat.CERT_STORE_ENABLED, "" + this.state));
        if (this.params != null && this.params.size() > 0) {
            parent.appendChild(this.params.getXMLNode(doc));
        }
        return parent;
    }

    public String getParentElementName() {
        return CryptOGAFormat.CERT_MGNT_STORES;
    }

    public String getElementName() {
        return CryptOGAFormat.CERT_STORE_PROFILE;
    }

    public void setXMLRecord(Node node) throws XMLRecordDataException {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() <= 0) {
            throw new XMLRecordDataException("CertStoreProfile", " Empty node was supplied " + node.toString());
        }
        try {
            CertStoreOperation cso = null;
            CertStoreParams pms = new CertStoreParams();
            int enabled = STATE_DISABLE;
            int i = 0;
            while (i < nodeList.getLength()) {
                if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                    String nv = Utils.nodeValue(nodeList.item(i));
                    String nn = Utils.nodeName(nodeList.item(i));
                    if (nn.equalsIgnoreCase(CryptOGAFormat.CERT_STORE_OPERATOR_NUMBER)) {
                        cso = CertStoreProfile.getCSOInstance(Integer.parseInt(nv));
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CERT_STORE_PARAMETERS)) {
                        pms.setXMLRecord(nodeList.item(i));
                    } else if (nn.equalsIgnoreCase(CryptOGAFormat.CERT_STORE_ENABLED)) {
                        enabled = Integer.parseInt(nv);
                    }
                }
                ++i;
            }
            this.certStore = cso;
            this.params = cso.getParameters();
            this.params.setProps(pms);
            this.state = enabled;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XMLRecordDataException("Authority", e.toString());
        }
    }

    public boolean isXMLNode(Node node) throws XMLRecordDataException {
        CertStoreProfile csp = new CertStoreProfile(node);
        return this.is(csp);
    }

    public void start() throws CertStoreStartFailException {
        if (!this.certStore.isStart()) {
            this.certStore.start(this.params);
        }
    }

    public void stop() throws CertStoreStopFailException {
        if (this.certStore.isStart()) {
            this.certStore.stop();
        }
    }
}

