/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.HouseKeeping;

import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.HouseKeeping.AgentProfile;

public class CryptoPolicyTaker {
    private AlgorithmSupportTable algoTable;
    public AlgorithmSet signingAlgoSet;
    public AlgorithmSet dataEncryptionAlgoSet;
    public AlgorithmSet keyWrappingAlgoSet;
    public AlgorithmSet encipherAlgoSet;
    public AlgorithmSet macAlgoSet;
    private AlgorithmProfile signingAlgo;
    private AlgorithmProfile dataEncryptionAlgo;
    private AlgorithmProfile keyWrappingAlgo;

    CryptoPolicyTaker(AlgorithmSupportTable algoTable, AgentProfile agent) throws AlgorithmSupportException {
        this.signingAlgoSet = algoTable.getSignatureAlgorithm();
        this.dataEncryptionAlgoSet = algoTable.getSymetricEncryptionAlgorithm();
        this.keyWrappingAlgoSet = algoTable.getAsymetricEncryptionAlgorithm();
        this.encipherAlgoSet = algoTable.getEncryptionAlgorithm();
        this.macAlgoSet = algoTable.getMessageDigestAlgorithm();
        String singingAlgoOID = agent.getSignatureAlgo();
        this.signingAlgo = singingAlgoOID.equalsIgnoreCase("NA") ? (AlgorithmProfile)this.signingAlgoSet.get(0) : this.signingAlgoSet.findByOID(agent.getSignatureAlgo());
        String encAlgoOID = agent.getEncryptionAlgo();
        this.dataEncryptionAlgo = encAlgoOID.equalsIgnoreCase("NA") ? (AlgorithmProfile)this.dataEncryptionAlgoSet.get(0) : this.dataEncryptionAlgoSet.findByOID(encAlgoOID);
        String wrappingAlgoOID = agent.getKeyWrapAlgo();
        this.keyWrappingAlgo = wrappingAlgoOID.equalsIgnoreCase("NA") ? (AlgorithmProfile)this.keyWrappingAlgoSet.get(0) : this.keyWrappingAlgoSet.findByOID(wrappingAlgoOID);
    }

    public AlgorithmProfile getSigningAlgo() {
        return this.signingAlgo;
    }

    public AlgorithmProfile getMessageDigestAlgo() throws AlgorithmSupportException {
        return this.macAlgoSet.findByName(this.signingAlgo.getMessageDigestAlgorithmName());
    }

    public AlgorithmProfile getEncryptionAlgo() {
        return this.dataEncryptionAlgo;
    }

    public AlgorithmProfile getKeyWrapAlgo() {
        return this.keyWrappingAlgo;
    }
}

