/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.HouseKeeping;

import java.awt.Container;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import th.co.oga.OperationCancelException;
import th.co.oga.security.pki.HouseKeeping.KeeperAuthenticator;
import th.co.oga.security.pki.PinCode;
import th.co.oga.security.utils.SpringUtils;

public class FormKeeperAuthenticator
extends JDialog
implements KeeperAuthenticator,
ActionListener {
    public static final long serialVersionUID = 1L;
    private JLabel blankLabel = new JLabel("");
    private JLabel passLabel = new JLabel("Enter Pin", 11);
    private JTextField passInput = new JPasswordField(10);
    private JButton submit = new JButton("Enter");
    private JButton cancel = new JButton("Cancel");
    private String operation;

    public FormKeeperAuthenticator() throws HeadlessException {
        super(new JFrame("Authentication"), "Authentication", true);
        super.setLocation(100, 100);
        this.setDefaultCloseOperation(0);
        this.submit.setActionCommand("Enter");
        this.submit.addActionListener(this);
        this.cancel.setActionCommand("Cancel");
        this.cancel.addActionListener(this);
        Container p = this.getRootPane().getContentPane();
        p.setLayout(new SpringLayout());
        p.add(this.passLabel);
        this.passLabel.setLabelFor(this.passInput);
        p.add(this.passInput);
        JPanel bPanel = new JPanel(new GridLayout(0, 2));
        bPanel.add(this.submit);
        bPanel.add(this.cancel);
        p.add(this.blankLabel);
        this.blankLabel.setLabelFor(bPanel);
        p.add(bPanel);
        SpringUtils.makeCompactGrid(p, 2, 2, 3, 3, 3, 3);
        this.pack();
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        this.operation = e.getActionCommand();
        if (e.getActionCommand().equals("Enter")) {
            if (this.passInput.getText().length() > 0) {
                this.setModal(false);
                this.setVisible(false);
                this.dispose();
            }
        } else {
            this.setModal(false);
            this.setVisible(false);
            this.dispose();
        }
    }

    public PinCode getLockPinCode(String agent) throws OperationCancelException {
        this.setTitle("Set " + agent + " 's PIN");
        this.operation = "Cancel";
        this.setModal(true);
        this.setVisible(true);
        if (this.operation.equalsIgnoreCase("Cancel")) {
            throw new OperationCancelException();
        }
        return new PinCode(this.passInput.getText().trim().toCharArray());
    }

    public PinCode getOpenPinCode(String agent) throws OperationCancelException {
        this.setTitle("Sign on to " + agent + "''s privacy room");
        this.operation = "Cancel";
        this.setModal(true);
        this.setVisible(true);
        if (this.operation.equalsIgnoreCase("Cancel")) {
            throw new OperationCancelException();
        }
        return new PinCode(this.passInput.getText().trim().toCharArray());
    }

    public static void main(String[] args) {
        FormKeeperAuthenticator form = new FormKeeperAuthenticator();
        try {
            form.getLockPinCode("Jeap");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

