/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.HouseKeeping;

import java.util.Iterator;
import th.co.oga.OperationCancelException;
import th.co.oga.security.pki.HouseKeeping.AgentList;
import th.co.oga.security.pki.HouseKeeping.AgentProfile;
import th.co.oga.security.pki.HouseKeeping.AgentProfileAlreadyExistException;
import th.co.oga.security.pki.HouseKeeping.AgentProfileNotFoundException;
import th.co.oga.security.pki.HouseKeeping.AgentProfileVerifyException;
import th.co.oga.security.pki.HouseKeeping.ConfigFailException;
import th.co.oga.security.pki.HouseKeeping.FormKeeperAuthenticator;
import th.co.oga.security.pki.HouseKeeping.KeeperAuthenticator;
import th.co.oga.security.pki.HouseKeeping.KeeperFatalException;
import th.co.oga.security.pki.HouseKeeping.KeeperSoftException;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.HouseKeeping.RoomCleaner;
import th.co.oga.security.pki.HouseKeeping.RoomConfigException;
import th.co.oga.security.pki.HouseKeeping.RoomForService;
import th.co.oga.security.pki.HouseKeeping.SaveHouse;
import th.co.oga.security.pki.HouseKeeping.SysConfig;
import th.co.oga.security.pki.PinCode;
import th.co.oga.security.xml.XMLConfigFileLoadException;
import th.co.oga.security.xml.XMLConfigFileManipulateException;
import th.co.oga.security.xml.XMLConfigFileNotFoundException;

public class HouseKeeper {
    private SaveHouse house;
    private SysConfig config;
    private AgentList agentList;
    KeeperAuthenticator authenticator;

    public HouseKeeper() throws KeeperFatalException {
        try {
            this.config = new SysConfig(String.valueOf(SaveHouse.getSysBase()) + SaveHouse.FS + "conf");
        }
        catch (Exception e) {
            throw new KeeperFatalException("sysConfig", e.toString());
        }
        this.house = this.config.getHouse();
        this.agentList = this.config.getAgentList();
        this.house.open();
    }

    public Iterator getAgentList() {
        return this.agentList.iterator();
    }

    public void registerAgent(AgentProfile agentProfile) throws XMLConfigFileManipulateException, AgentProfileVerifyException, AgentProfileAlreadyExistException, ConfigFailException {
        AgentList al;
        this.agentList = al = this.config.addAgent(agentProfile);
    }

    public void updateAgentProfile(AgentProfile profile) throws AgentProfileNotFoundException, AgentProfileVerifyException, ConfigFailException {
        AgentList al;
        this.agentList = al = this.config.updateAgent(profile);
    }

    public void removeAgentProfile(AgentProfile profile) throws AgentProfileNotFoundException, AgentProfileVerifyException, ConfigFailException {
        AgentList al;
        this.agentList = al = this.config.dropAgent(profile);
    }

    public boolean reloadAgent(AgentProfile agent) throws XMLConfigFileLoadException, XMLConfigFileNotFoundException {
        if (!this.config.isUpdate()) {
            AgentProfile ap;
            this.config.reload();
            this.agentList = this.config.getAgentList();
            agent = ap = this.agentList.getAgentProfile(agent.getId());
            return true;
        }
        return false;
    }

    public Room reserveRoom(String agentId) throws KeeperFatalException, KeeperSoftException {
        AgentProfile agentProfile = this.agentList.getAgentProfile(agentId);
        Room room = new Room(this.house);
        room.setCleaner(new RoomCleaner(this));
        room.setOwner(agentProfile);
        room.setHouseKeeper(this);
        return room;
    }

    public RoomForService getRoomForService(String agentId) throws KeeperFatalException, RoomConfigException {
        AgentProfile agentProfile = this.agentList.getAgentProfile(agentId);
        RoomForService room = new RoomForService(this.house);
        room.setOwner(agentProfile);
        return room;
    }

    public String getHelpLocaltion() {
        return String.valueOf(SaveHouse.getSysBase()) + this.house.getPathSeparator() + "help";
    }

    public void setAuthenticator(KeeperAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public Room getMyRoom() throws AgentProfileVerifyException, KeeperFatalException, KeeperSoftException, OperationCancelException {
        Room myRoom = null;
        AgentProfile myAgent = AgentProfile.getMyProfile();
        try {
            this.registerAgent(myAgent);
        }
        catch (AgentProfileAlreadyExistException agentProfileAlreadyExistException) {
        }
        catch (XMLConfigFileManipulateException e) {
            throw new KeeperFatalException(e);
        }
        catch (ConfigFailException e) {
            throw new KeeperFatalException(e);
        }
        myRoom = this.reserveRoom(myAgent.getId());
        if (myRoom.isSafe()) {
            if (this.authenticator == null) {
                this.authenticator = new FormKeeperAuthenticator();
            }
            PinCode pin = this.authenticator.getOpenPinCode(myAgent.getId());
            myRoom.open(pin);
        } else {
            myRoom.open(null);
        }
        return myRoom;
    }
}

