/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.HouseKeeping;

import java.io.File;
import java.io.IOException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Certification.CSRGeneration;
import th.co.oga.security.pki.Certification.CSRProfile;
import th.co.oga.security.pki.Certification.CSRProfileVerifyException;
import th.co.oga.security.pki.Certification.CertPackage;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertPackageTypeNotSupportException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.Certification.InternalCertProfile;
import th.co.oga.security.pki.Engine.SecureEngine;
import th.co.oga.security.pki.Engine.SecureModule;
import th.co.oga.security.pki.Engine.SecureProviderName;
import th.co.oga.security.pki.Engine.SecureProviderType;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.AgentProfile;
import th.co.oga.security.pki.HouseKeeping.CAList;
import th.co.oga.security.pki.HouseKeeping.CRLList;
import th.co.oga.security.pki.HouseKeeping.CRLRegister;
import th.co.oga.security.pki.HouseKeeping.CSRList;
import th.co.oga.security.pki.HouseKeeping.CertStoreList;
import th.co.oga.security.pki.HouseKeeping.CertStoreProfile;
import th.co.oga.security.pki.HouseKeeping.ConfigFailException;
import th.co.oga.security.pki.HouseKeeping.CryptoPolicyTaker;
import th.co.oga.security.pki.HouseKeeping.HouseKeeper;
import th.co.oga.security.pki.HouseKeeping.KeeperFatalException;
import th.co.oga.security.pki.HouseKeeping.ProfileAlreadyExistException;
import th.co.oga.security.pki.HouseKeeping.ProfileNotFoundException;
import th.co.oga.security.pki.HouseKeeping.RoomBuildException;
import th.co.oga.security.pki.HouseKeeping.RoomCleanException;
import th.co.oga.security.pki.HouseKeeping.RoomCleaner;
import th.co.oga.security.pki.HouseKeeping.RoomCloseException;
import th.co.oga.security.pki.HouseKeeping.RoomConfig;
import th.co.oga.security.pki.HouseKeeping.RoomConfigException;
import th.co.oga.security.pki.HouseKeeping.RoomLockException;
import th.co.oga.security.pki.HouseKeeping.RoomOpenException;
import th.co.oga.security.pki.HouseKeeping.RoomOperationException;
import th.co.oga.security.pki.HouseKeeping.RoomType;
import th.co.oga.security.pki.HouseKeeping.RoomTypeNotSuppliedException;
import th.co.oga.security.pki.HouseKeeping.SaveHouse;
import th.co.oga.security.pki.HouseKeeping.TokenList;
import th.co.oga.security.pki.HouseKeeping.TrustedPolicyTaker;
import th.co.oga.security.pki.Operation.CertStoreStartFailException;
import th.co.oga.security.pki.Operation.PFXOperation;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operation.TokenOperationNotSupportException;
import th.co.oga.security.pki.Operation.TokenOperatorBuildException;
import th.co.oga.security.pki.Operation.TokenOperatorLockException;
import th.co.oga.security.pki.Operation.TokenOperatorOpenException;
import th.co.oga.security.pki.Operation.TokenOperatorOperationFailException;
import th.co.oga.security.pki.Operator.CryptoOperator;
import th.co.oga.security.pki.Operator.SecureOperator;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.Operator.TokenOperator;
import th.co.oga.security.pki.Packaging.SecurePackager;
import th.co.oga.security.pki.Packaging.SecureTaker;
import th.co.oga.security.pki.PinCode;
import th.co.oga.security.pki.Trusted.Authority;
import th.co.oga.security.pki.Trusted.ServiceName;
import th.co.oga.security.pki.Trusted.TrustedPolicies;
import th.co.oga.security.pki.service.RoomServiceDeamond;
import th.co.oga.security.pki.x.CRL.CRLProfile;
import th.co.oga.security.xml.XMLConfigEngineException;
import th.co.oga.security.xml.XMLConfigFileLoadException;
import th.co.oga.security.xml.XMLConfigFileNotFoundException;
import th.co.oga.security.xml.XMLRecordDataException;

public class Room {
    private AgentProfile owner;
    private SaveHouse house;
    private String DoorState;
    private RoomType roomType;
    private RoomConfig config;
    private CSRList csrList;
    private CAList caList;
    private CRLRegister crlReg;
    private CRLList crlList;
    private CertStoreList csl;
    private SecureEngine engine;
    private TokenList operators;
    private RoomCleaner cleaner = null;
    private Logger logger;
    private RoomServiceDeamond service;
    private HouseKeeper keeper;

    protected Room(SaveHouse house) {
        this.house = house;
        this.operators = new TokenList();
    }

    protected void setOwner(AgentProfile agentProfile) throws KeeperFatalException, SecureStoreException {
        if (agentProfile == null) {
            throw new KeeperFatalException("Room", "Can not applied unknow(null) agency .");
        }
        try {
            this.roomType = RoomType.getInstance(agentProfile.getAgentType());
            this.owner = agentProfile;
            this.engine = agentProfile.getEngine();
            this.build();
            String pattern = "%d\t%p\t%m\t%n";
            PatternLayout layout = new PatternLayout(pattern);
            this.logger = Logger.getLogger((String)"CryptOGA");
            this.setProviders();
            try {
                this.logger.addAppender((Appender)new FileAppender((Layout)layout, String.valueOf(this.getHome()) + this.house.getPathSeparator() + "agent_process.log", true));
            }
            catch (IOException e1) {
                SaveHouse.TraceInfo("Can not allocate log location for privacy room I O Error");
            }
            this.service = new RoomServiceDeamond(this);
            SaveHouse.setRoomService(this.service);
        }
        catch (RoomTypeNotSuppliedException e) {
            throw new KeeperFatalException("Room", e.toString());
        }
    }

    protected void setHouseKeeper(HouseKeeper hk) {
        this.keeper = hk;
    }

    public boolean reloadOwner() throws XMLConfigFileNotFoundException, XMLConfigFileLoadException {
        return this.keeper.reloadAgent(this.owner);
    }

    protected void setProviders() throws KeeperFatalException {
        SecureProviderName prdName = null;
        try {
            int pointer = 0;
            while (pointer < this.engine.size()) {
                SecureModule module = (SecureModule)this.engine.get(pointer);
                prdName = SecureProviderName.getInstance(module.getProvider().getName());
                if (!SecureProviderName.findProviderName(prdName.getName())) {
                    Security.addProvider(prdName.getProviderInstance());
                }
                ++pointer;
            }
        }
        catch (Exception e) {
            throw new KeeperFatalException("Room", "Can not apply all Secure Provider, " + prdName.getName() + ", Error message " + e.toString());
        }
    }

    protected void setCleaner(RoomCleaner cleaner) {
        this.cleaner = cleaner;
    }

    public void lock(PinCode pin) throws RoomLockException {
        if (this.operators.size() > 0) {
            Iterator itr = this.operators.iterator();
            while (itr.hasNext()) {
                try {
                    ((TokenOperator)itr.next()).lock(pin);
                }
                catch (TokenOperatorLockException e) {
                    throw new RoomLockException(e.toString());
                }
                catch (TokenOperationNotSupportException tokenOperationNotSupportException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isSafe() {
        if (this.operators.size() > 0) {
            TokenOperator storeToken = this.operators.getTokenOperator(this.engine.getSecureModule(SecureProviderType.STORE));
            return storeToken.isSafe();
        }
        return false;
    }

    public void changPIN(PinCode oldPin, PinCode newPin) throws TokenOperatorLockException, TokenOperationNotSupportException {
        Iterator itr = this.operators.iterator();
        while (itr.hasNext()) {
            ((TokenOperator)itr.next()).lock(oldPin, newPin);
        }
    }

    public void open(PinCode pin) throws RoomOpenException {
        int isLogedIn = 0;
        SaveHouse.TraceInfo("Start open " + this.owner.getName() + "'s room.");
        this.traceInfo("Authenticate to privacy room.");
        try {
            for (TokenOperator oper : this.operators) {
                if (oper.isOpened()) {
                    isLogedIn = 1;
                    continue;
                }
                oper.open(this.owner, pin);
                isLogedIn = 2;
            }
        }
        catch (TokenOperatorOpenException e) {
            throw new RoomOpenException(e.toString());
        }
        if (isLogedIn == 0) {
            throw new RoomOpenException("The authentication state is not applicated, there are no any operators required to authenticated. ");
        }
        if (isLogedIn == 1) {
            this.traceInfo("Room was opened with no authenticated.");
            SaveHouse.TraceInfo("Room was opened with no authentication !.");
        }
        this.traceInfo("Room was opened.");
        SaveHouse.TraceInfo("Room was opened.");
    }

    public void traceInfo(String mess) {
        if (this.logger != null) {
            this.logger.info((Object)mess);
        }
    }

    public void scandTokens() {
        for (TokenOperator oper : this.operators) {
            oper.reloadTokens();
        }
    }

    public void refreshToken() {
        try {
            SecureStoreOperator sso = this.getSecureStoreOperator();
            List certList = sso.getCertificates("USER Certificate");
        }
        catch (SecureStoreException secureStoreException) {
            // empty catch block
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public RoomServiceDeamond getService() {
        return this.service;
    }

    public void close() throws RoomCloseException {
        if (this.service != null) {
            this.service.stop();
        }
        try {
            this.operators.closeAllToken();
        }
        catch (TokenOperatorOperationFailException e) {
            throw new RoomCloseException(e.toString());
        }
    }

    public String listOperators() {
        String list = String.valueOf(this.operators.size()) + " Operators is present " + "\r\n";
        for (TokenOperator oper : this.operators) {
            list = String.valueOf(list) + "\r\n" + oper.about();
        }
        return list;
    }

    public String about() {
        String about_text = String.valueOf(this.owner.getName()) + "'s privacy room ..." + "\r\n Privacy Room : " + this.getHome() + "\r\n" + this.listOperators();
        return about_text;
    }

    private String getHome() {
        if (this.roomType.getLocation().equalsIgnoreCase("I")) {
            return String.valueOf(this.house.getHome()) + this.house.getPathSeparator() + ".CryptOGA";
        }
        return String.valueOf(this.house.getRoomBase()) + this.house.getPathSeparator() + this.owner.getId();
    }

    public String getLogLocaltion() {
        return String.valueOf(this.getHome()) + this.house.getPathSeparator() + "logs";
    }

    public String getHelpLocaltion() {
        return String.valueOf(this.house.getRoomBase()) + this.house.getPathSeparator() + "help";
    }

    public String getOsHome() {
        return this.house.getHome();
    }

    private void build() throws RoomBuildException, TokenOperatorBuildException {
        SaveHouse.TraceInfo("Start initialize " + this.owner.getName() + "'room .");
        boolean storeStatus = true;
        if (!this.house.isOpened()) {
            throw new RoomBuildException("House was not opened.");
        }
        String storeBase = this.getHome();
        File base = new File(storeBase);
        if (!base.exists()) {
            storeStatus = base.mkdir();
        }
        try {
            try {
                this.config = new RoomConfig(storeBase);
                this.loadRoomConfig();
            }
            catch (XMLConfigFileNotFoundException e) {
                try {
                    RoomConfig.initConfigFile(storeBase);
                    this.config = new RoomConfig(storeBase);
                    this.loadRoomConfig();
                }
                catch (Exception e2) {
                    throw new RoomConfigException(e2.toString());
                }
            }
            catch (ConfigFailException e) {
                throw new RoomConfigException(e.toString());
            }
            catch (XMLConfigFileLoadException e) {
                throw new RoomConfigException(e.toString());
            }
            catch (XMLRecordDataException e) {
                throw new RoomConfigException(e.toString());
            }
            catch (XMLConfigEngineException e) {
                throw new RoomConfigException(e.toString());
            }
        }
        catch (RoomConfigException e) {
            throw new RoomBuildException(e.toString());
        }
        try {
            try {
                this.crlReg = new CRLRegister(storeBase);
                this.crlList = this.crlReg.getProfileList();
            }
            catch (XMLConfigFileNotFoundException e) {
                try {
                    CRLRegister.initConfigFile(storeBase);
                    this.crlReg = new CRLRegister(storeBase);
                    this.csrList = this.config.getProfileList();
                }
                catch (Exception e2) {
                    throw new RoomConfigException(e2.toString());
                }
            }
            catch (ConfigFailException e) {
                throw new RoomConfigException(e.toString());
            }
            catch (XMLConfigFileLoadException e) {
                throw new RoomConfigException(e.toString());
            }
            catch (XMLRecordDataException e) {
                throw new RoomConfigException(e.toString());
            }
            catch (XMLConfigEngineException e) {
                throw new RoomConfigException(e.toString());
            }
        }
        catch (RoomConfigException e) {
            throw new RoomBuildException(e.toString());
        }
        this.engine = this.owner.getEngine();
        int pointer = 0;
        while (pointer < this.engine.size()) {
            SecureModule module = (SecureModule)this.engine.get(pointer);
            TokenOperator oper = this.operators.addToken(module);
            if (!oper.isBuilded()) {
                oper.build(base);
            }
            ++pointer;
        }
        SaveHouse.TraceInfo("Finish room initialization.");
    }

    private void loadRoomConfig() {
        this.csrList = this.config.getProfileList();
        this.caList = this.config.getCAList();
        this.csl = this.config.getCertStoreList();
    }

    public boolean updateRoomConfig() throws ConfigFailException {
        if (this.config.isUpdate()) {
            this.config.reload();
            this.loadRoomConfig();
            return true;
        }
        return false;
    }

    public void erase() throws TokenOperatorOperationFailException, RoomCleanException {
        this.operators.wipe(this.engine.getSecureModule(SecureProviderType.STORE));
        try {
            this.cleaner.dropAgent(this.getOwner());
        }
        catch (Exception e) {
            throw new RoomCleanException("Room cleaner error while unregister agent as, " + e.getMessage());
        }
    }

    public CryptoOperator getCryptoOperator() {
        return this.operators.getCeryptoOperator(this.engine.getSecureModule(SecureProviderType.CRYPTO));
    }

    public SecureStoreOperator getSecureStoreOperator() {
        SecureStoreOperator sso = this.operators.getSecureStoreOperator(this.engine.getSecureModule(SecureProviderType.STORE));
        sso.setCertStoreList(this.csl);
        return sso;
    }

    public SecureOperator getSecureOperator() {
        return new SecureOperator(this.getSecureStoreOperator(), this.getCryptoOperator());
    }

    public ServiceName[] getAllServiceNames() {
        return ServiceName.getAllServiceName();
    }

    public void updateAuthority(Authority authority) throws ProfileAlreadyExistException, ProfileNotFoundException, ConfigFailException {
        authority.pack();
        this.caList = this.caList.indexOf(authority) > -1 ? this.config.updateProfile(authority) : this.config.addProfile(authority);
    }

    public void removeAuthority(Authority authority) throws ProfileNotFoundException, ConfigFailException {
        this.caList = this.config.dropProfile(authority);
    }

    public Authority[] getAuthorities() throws SecureStoreException, ASN1Exception {
        CertProfile[] caCers = this.getCaCertificates();
        Authority[] authorities = new Authority[caCers.length];
        int i = 0;
        while (i < caCers.length) {
            authorities[i] = this.getAuthority(caCers[i]);
            ++i;
        }
        return authorities;
    }

    public Authority[] getAuthoritiesByService(ServiceName service) {
        ArrayList<Authority> ats = new ArrayList<Authority>();
        int i = 0;
        while (i < this.caList.size()) {
            Authority a = (Authority)this.caList.get(i);
            if (a.isServe(service)) {
                ats.add(a);
            }
            ++i;
        }
        Authority[] authorities = new Authority[ats.size()];
        int i2 = 0;
        while (i2 < ats.size()) {
            authorities[i2] = (Authority)ats.get(i2);
            ++i2;
        }
        return authorities;
    }

    public Authority getAuthority(CertProfile caCert) throws ASN1Exception {
        String atName = caCert.getAuthorityName();
        Authority authority = this.caList.getAuthority(atName);
        if (authority == null) {
            authority = Authority.getInstance(caCert);
        }
        return authority;
    }

    public Authority getAuthority(String name) {
        return this.caList.getAuthority(name);
    }

    public CAList getCAList() {
        return this.caList;
    }

    public void setTrustedPolicies(TrustedPolicies policies) throws ConfigFailException {
        this.config.applyTrustedPolicies(policies);
    }

    public TrustedPolicies getTrustedPolicies() {
        return this.config.getTrustedPolicies();
    }

    public TrustedPolicyTaker getTrustedPolicyTaker() {
        return new TrustedPolicyTaker(this);
    }

    public CryptoPolicyTaker getCryptoPolicyTaker() throws AlgorithmSupportException {
        return new CryptoPolicyTaker(this.getCryptoOperator().getSupportAlgorithm(), this.getOwner());
    }

    public void updateCertStoreProfile(CertStoreProfile csp) throws ConfigFailException, ProfileNotFoundException, ProfileAlreadyExistException {
        this.csl = this.csl.indexOf(csp) > -1 ? this.config.updateProfile(csp) : this.config.addProfile(csp);
    }

    public void save(CertStoreList tbuCSL) throws ConfigFailException, ProfileNotFoundException, ProfileAlreadyExistException {
        if (tbuCSL.size() > 0) {
            int i = 0;
            while (i < tbuCSL.size()) {
                CertStoreProfile csp = (CertStoreProfile)tbuCSL.get(i);
                this.updateCertStoreProfile(csp);
                ++i;
            }
        }
    }

    public CertStoreList getCertStoreList() {
        if (this.csl.size() > 0) {
            return this.csl;
        }
        return this.getSecureStoreOperator().getSupportedCertStore();
    }

    private void activeCertStore() throws CertStoreStartFailException {
        SecureStoreOperator sso = this.getSecureStoreOperator();
        sso.setCertStoreList(this.csl);
    }

    public CSRGeneration getCSRGenerator() throws RoomOperationException {
        try {
            SecureStoreOperator sso = this.getSecureStoreOperator();
            CSRGeneration cr = sso.getCSRGenerator();
            cr.setSecureAgent(this.owner);
            return cr;
        }
        catch (Exception e) {
            throw new RoomOperationException(e.toString());
        }
    }

    public boolean keepCSR(CSRProfile csrProfile) {
        try {
            this.csrList = this.config.addProfile(csrProfile);
            return true;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
    }

    public boolean updateCSR(CSRProfile csrProfile) throws CSRProfileVerifyException, ProfileNotFoundException, ConfigFailException {
        this.csrList = this.config.updateProfile(csrProfile);
        return true;
    }

    public boolean deleteCSR(CSRProfile csrProfile) {
        try {
            SecureStoreOperator sso = this.getSecureStoreOperator();
            this.csrList = this.config.dropProfile(csrProfile);
            sso.deletePrivateKey(csrProfile.getPublicKey());
            return true;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
    }

    public CSRList getCSRList() {
        return this.csrList;
    }

    public void keepCRL(CRLProfile crlProfile) throws SecureStoreException, ConfigFailException {
        SecureStoreOperator sso = this.getSecureStoreOperator();
        X500Principal issueName = crlProfile.getIssueName();
        CertProfile issueCert = null;
        List list = sso.getCertificates("CA Certificate");
        int i = 0;
        while (i < list.size()) {
            CertProfile cer = (CertProfile)list.get(i);
            if (cer.isSubject(issueName)) {
                issueCert = cer;
                break;
            }
            ++i;
        }
        if (issueCert != null && this.crlReg.isUpdate(crlProfile)) {
            this.crlList = this.crlReg.setProfile(crlProfile);
        }
    }

    public boolean reloadCRL() throws ConfigFailException {
        if (this.crlReg.isUpdate()) {
            this.crlList = this.crlReg.reload();
            return true;
        }
        return false;
    }

    public CRLList getCRLList() {
        return this.crlList;
    }

    public Iterator getToBeUpdateCRLAuthorities() {
        Authority[] auths = this.getAuthoritiesByService(ServiceName.CRL);
        ArrayList<Authority> list = new ArrayList<Authority>();
        Date date = Calendar.getInstance().getTime();
        int i = 0;
        while (i < auths.length) {
            CRLProfile crl = this.crlList.getProfile(auths[i].getSubjectName().toString());
            if (crl == null) {
                list.add(auths[i]);
            } else {
                try {
                    Date ld = crl.getLastUpdate();
                    if (ld == null) {
                        list.add(auths[i]);
                    } else if (ld.before(date)) {
                        list.add(auths[i]);
                    }
                }
                catch (ParseException e) {
                    list.add(auths[i]);
                }
            }
            ++i;
        }
        return list.iterator();
    }

    public void importCertPackage(CertPackage certPackage) throws CertPackageTypeNotSupportException, CertPackageException {
        this.getSecureStoreOperator().importCertPackage(certPackage);
    }

    public Iterator getCerts() throws SecureStoreException {
        return this.getSecureStoreOperator().getCertificates("USER Certificate").iterator();
    }

    public CertProfile getFirstCertificate() throws SecureStoreException {
        CertProfile defaultCert = null;
        try {
            defaultCert = this.owner.getDefaultCertificate();
        }
        catch (IOException e) {
            throw new SecureStoreException("Error while get the default certificate, IO Error.");
        }
        catch (CertificateException e) {
            throw new SecureStoreException("Invalid default certificate, " + e.getMessage());
        }
        if (defaultCert == null) {
            SecureStoreOperator sOper = this.getSecureStoreOperator();
            List cers = sOper.getCertificates("USER Certificate");
            if (cers.size() == 0) {
                throw new SecureStoreException("There are no any agent's certificate in store.");
            }
            if (cers.size() == 1) {
                defaultCert = (CertProfile)cers.get(0);
            }
        }
        if (defaultCert == null) {
            throw new SecureStoreException("Can not specify the default certificate.");
        }
        return defaultCert;
    }

    public CertProfile findCertificateByAlias(String alias) throws SecureStoreException, EntryNotFoundException {
        List peopleCertList = this.getSecureStoreOperator().getCertificates("TRUSTED Certificate");
        InternalCertProfile certProfile = null;
        int i = 0;
        while (i < peopleCertList.size()) {
            InternalCertProfile iCert = (InternalCertProfile)peopleCertList.get(i);
            if (iCert.isAlias(alias)) {
                certProfile = iCert;
            }
            ++i;
        }
        if (certProfile == null) {
            throw new EntryNotFoundException(String.valueOf(alias) + " certificate ");
        }
        return certProfile;
    }

    public CertProfile findCertificate(X500Principal issuer, String sn) throws SecureStoreException, EntryNotFoundException {
        SecureStoreOperator sso = this.getSecureStoreOperator();
        List peopleCertList = sso.getCertificates("TRUSTED Certificate");
        InternalCertProfile certProfile = null;
        int i = 0;
        while (i < peopleCertList.size()) {
            InternalCertProfile iCert = (InternalCertProfile)peopleCertList.get(i);
            String isn = iCert.getSerialNumber().toString();
            if (issuer.equals(iCert.getX509Cert().getIssuerX500Principal()) && sn.compareTo(isn) == 0) {
                certProfile = iCert;
            }
            ++i;
        }
        if (certProfile == null) {
            throw new EntryNotFoundException("[" + issuer.getName() + " - " + sn + "] Certificate ");
        }
        return certProfile;
    }

    public void applyPolicy(SecurePackager packager) throws AlgorithmSupportException, SecureStoreException, EntryNotFoundException {
        packager.applyPolicy(this);
    }

    public void applyPolicy(SecureTaker taker) throws AlgorithmSupportException, SecureStoreException, EntryNotFoundException {
        taker.applyPolicy(this);
    }

    public CertProfile[] getCertificates() throws SecureStoreException {
        SecureStoreOperator sso = this.getSecureStoreOperator();
        List certList = sso.getCertificates("USER Certificate");
        CertProfile[] certs = new CertProfile[certList.size()];
        int i = 0;
        while (i < certList.size()) {
            certs[i] = (CertProfile)certList.get(i);
            ++i;
        }
        return certs;
    }

    public CertProfile[] getTrustedCertificates() throws SecureStoreException {
        SecureStoreOperator sso = this.getSecureStoreOperator();
        List certList = sso.getCertificates("TRUSTED Certificate");
        CertProfile[] certs = new CertProfile[certList.size()];
        int i = 0;
        while (i < certList.size()) {
            certs[i] = (CertProfile)certList.get(i);
            ++i;
        }
        return certs;
    }

    public CertProfile getIssuerCertificate(CertProfile userCert) throws IOException, EntryNotFoundException, CertProfileException, CertificateException {
        SecureStoreOperator sso = this.getSecureStoreOperator();
        return sso.getIssuerCertificate(userCert);
    }

    public CertProfile[] getCaCertificates() throws SecureStoreException {
        SecureStoreOperator sso = this.getSecureStoreOperator();
        List certList = sso.getCertificates("CA Certificate");
        CertProfile[] certs = new CertProfile[certList.size()];
        int i = 0;
        while (i < certList.size()) {
            certs[i] = (CertProfile)certList.get(i);
            ++i;
        }
        return certs;
    }

    public AgentProfile getOwner() {
        return this.owner;
    }

    public void dumpStore() {
        InternalCertProfile iCert;
        int i;
        SecureStoreOperator sso = this.getSecureStoreOperator();
        System.out.println("CA Certificates in store :");
        try {
            List caCertList = sso.getCertificates("CA Certificate");
            i = 0;
            while (i < caCertList.size()) {
                iCert = (InternalCertProfile)caCertList.get(i);
                System.out.println("\tEntry Alias :" + iCert.getFriendlyName() + " S/N:" + iCert.getSerialNumber() + " [SubjName:" + iCert.getX509Cert().getSubjectDN().toString() + "]");
                ++i;
            }
        }
        catch (Exception caCertList) {
            // empty catch block
        }
        System.out.println("People Certificates in store :");
        try {
            List peopleCertList = sso.getCertificates("TRUSTED Certificate");
            i = 0;
            while (i < peopleCertList.size()) {
                iCert = (InternalCertProfile)peopleCertList.get(i);
                System.out.println("\tEntry Alias :" + iCert.getFriendlyName() + " S/N:" + iCert.getSerialNumber() + " [SubjName:" + iCert.getX509Cert().getSubjectDN().toString() + "]");
                ++i;
            }
        }
        catch (Exception peopleCertList) {
            // empty catch block
        }
        System.out.println("User Certificate in store:");
        try {
            List userCertList = sso.getCertificates("USER Certificate");
            i = 0;
            while (i < userCertList.size()) {
                iCert = (InternalCertProfile)userCertList.get(i);
                System.out.println("\tEntry Alias :" + iCert.getFriendlyName() + " S/N:" + iCert.getSerialNumber() + " [SubjName:" + iCert.getX509Cert().getSubjectDN().toString() + "]");
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTokenInfo() {
        SecureStoreOperator sso = this.getSecureStoreOperator();
        return sso.getInfos();
    }

    public PFXOperation getPFXDeviceOperator() throws SecureStoreException {
        return this.getSecureStoreOperator().getPKCS12Device();
    }

    public void setTokenPasswordCalledBack(Object o) throws TokenOperatorOperationFailException {
        this.operators.setPasswordCalledBack(o);
    }
}

