/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.HouseKeeping;

import java.io.File;
import org.w3c.dom.NodeList;
import th.co.oga.security.pki.Certification.CSRProfile;
import th.co.oga.security.pki.Certification.CSRProfileVerifyException;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.HouseKeeping.CAList;
import th.co.oga.security.pki.HouseKeeping.CSRList;
import th.co.oga.security.pki.HouseKeeping.CertStoreList;
import th.co.oga.security.pki.HouseKeeping.CertStoreProfile;
import th.co.oga.security.pki.HouseKeeping.ConfigFailException;
import th.co.oga.security.pki.HouseKeeping.ProfileAlreadyExistException;
import th.co.oga.security.pki.HouseKeeping.ProfileNotFoundException;
import th.co.oga.security.pki.Trusted.Authority;
import th.co.oga.security.pki.Trusted.TrustedPolicies;
import th.co.oga.security.utils.SysEnv;
import th.co.oga.security.xml.Explorable;
import th.co.oga.security.xml.XMLConfigEngineException;
import th.co.oga.security.xml.XMLConfigFile;
import th.co.oga.security.xml.XMLConfigFileBackupException;
import th.co.oga.security.xml.XMLConfigFileLoadException;
import th.co.oga.security.xml.XMLConfigFileManipulateException;
import th.co.oga.security.xml.XMLConfigFileNotFoundException;
import th.co.oga.security.xml.XMLConfigFilePreException;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class RoomConfig
extends XMLConfigFile
implements Explorable {
    protected String rootConfig = CryptOGAFormat.ROOM_CONFIG_ROOT;
    protected CSRList csrList;
    protected String csrParentName = CryptOGAFormat.CSR_PARENT;
    protected CAList caList;
    protected String caParentName = CryptOGAFormat.CA_PARENT;
    protected CertStoreList csl;
    protected String cslParentName = CryptOGAFormat.CERT_STORE_PARENT;
    protected TrustedPolicies trustedPolicies = new TrustedPolicies();
    protected String trustedParentName = CryptOGAFormat.TRUSTED_PARENT;
    protected String trusted = CryptOGAFormat.TRUSTED;

    public RoomConfig(String base) throws ConfigFailException, XMLConfigFileNotFoundException, XMLConfigFileLoadException, XMLRecordDataException, XMLConfigEngineException {
        super(String.valueOf(base) + SysEnv.FS + CryptOGAFormat.ROOM_CONFIG_FILE_NAME);
        try {
            this.loadProfileList();
            this.loadCAList();
            this.loadCertStoreList();
            this.loadTrustedPolicies();
        }
        catch (CSRProfileVerifyException e) {
            throw new ConfigFailException("Load CSR List ", e.getMessage());
        }
        catch (ProfileAlreadyExistException e) {
            throw new ConfigFailException("Load all profiles ", e.getMessage());
        }
    }

    public static void initConfigFile(String base) throws ConfigFailException {
        File configFile = new File(String.valueOf(base) + SysEnv.FS + CryptOGAFormat.ROOM_CONFIG_FILE_NAME);
        if (!configFile.exists()) {
            String configText = "";
            try {
                String csrTag = "\r\n\t\t" + XMLUtils.elementTag(CryptOGAFormat.CSR_PARENT, "");
                String caTag = "\r\n\t\t" + XMLUtils.elementTag(CryptOGAFormat.CA_PARENT, "");
                configText = String.valueOf(configText) + "\r\n\t" + XMLUtils.elementTag(CryptOGAFormat.ROOM_CONFIG_ROOT, String.valueOf(csrTag) + caTag);
                XMLUtils.initXMLFile(configFile, configText);
            }
            catch (Exception e) {
                throw new ConfigFailException("Error while room configuration file initialization ", e.toString());
            }
        }
    }

    public String explore() {
        String rtn = "";
        NodeList nl = super.getNodeList(this.rootConfig);
        int c = 0;
        while (c < nl.getLength()) {
            rtn = String.valueOf(rtn) + XMLUtils.nodeExplorer(nl.item(c), "", 0);
            ++c;
        }
        nl = super.getNodeList(this.csrParentName);
        c = 0;
        while (c < nl.getLength()) {
            rtn = String.valueOf(rtn) + XMLUtils.nodeExplorer(nl.item(c), "", 0);
            ++c;
        }
        nl = super.getNodeList(this.caParentName);
        c = 0;
        while (c < nl.getLength()) {
            rtn = String.valueOf(rtn) + XMLUtils.nodeExplorer(nl.item(c), "", 0);
            ++c;
        }
        nl = super.getNodeList(this.trustedParentName);
        c = 0;
        while (c < nl.getLength()) {
            rtn = String.valueOf(rtn) + XMLUtils.nodeExplorer(nl.item(c), "", 0);
            ++c;
        }
        return rtn;
    }

    public CSRList getProfileList() {
        return this.csrList;
    }

    public CSRList addProfile(CSRProfile[] profiles) throws ConfigFailException, ProfileAlreadyExistException, XMLConfigFileManipulateException {
        if (profiles.length > 1) {
            int i = 0;
            while (i < profiles.length) {
                if (profiles[i].isRegistered() || this.csrList.indexOf(profiles[i]) > -1) {
                    throw new ProfileAlreadyExistException(profiles[i].getSN());
                }
                try {
                    this.addElement(profiles[i]);
                }
                catch (Exception e) {
                    throw new ConfigFailException("Add new profile to xml ", e.toString());
                }
                ++i;
            }
            try {
                this.apply();
            }
            catch (Exception e) {
                throw new XMLConfigFileManipulateException(e.toString());
            }
        }
        return this.csrList;
    }

    public CSRList addProfile(CSRProfile profile) throws ConfigFailException, XMLConfigFileManipulateException, ProfileAlreadyExistException, CSRProfileVerifyException {
        if (profile.isRegistered()) {
            throw new ProfileAlreadyExistException(" ");
        }
        if (this.csrList.indexOf(profile) > -1) {
            throw new ProfileAlreadyExistException(profile.getSN());
        }
        try {
            this.addElement(profile);
            this.apply();
        }
        catch (Exception e) {
            throw new ConfigFailException("Add new profile to xml ", e.toString());
        }
        return this.csrList;
    }

    public CSRList updateProfile(CSRProfile profile) throws ConfigFailException, ProfileNotFoundException, CSRProfileVerifyException {
        profile.verify();
        if (this.csrList.indexOf(profile) < 0) {
            throw new ProfileNotFoundException(profile.getSN());
        }
        try {
            this.updElement(profile);
            this.apply();
        }
        catch (Exception e) {
            throw new ConfigFailException("Update Profile to config file ", e.toString());
        }
        return this.csrList;
    }

    public CSRList dropProfile(CSRProfile profile) throws ConfigFailException, ProfileNotFoundException, CSRProfileVerifyException {
        profile.verify();
        if (this.csrList.indexOf(profile) < 0) {
            throw new ProfileNotFoundException(profile.getSN());
        }
        try {
            this.deleteElement(profile);
            this.apply();
        }
        catch (Exception e) {
            throw new ConfigFailException("Delete profile from config file ", e.toString());
        }
        return this.csrList;
    }

    private void apply() throws XMLConfigFileManipulateException, ConfigFailException {
        try {
            String updNo = this.beginUpdate();
            this.flushUpdate(updNo);
        }
        catch (XMLConfigFileNotFoundException e) {
            throw new XMLConfigFileManipulateException(e.toString());
        }
        catch (XMLConfigFileBackupException e) {
            throw new XMLConfigFileManipulateException(e.toString());
        }
        catch (XMLConfigEngineException e) {
            throw new XMLConfigFileManipulateException(e.toString());
        }
        catch (XMLConfigFilePreException e) {
            throw new XMLConfigFileManipulateException(e.toString());
        }
        this.reload();
    }

    public void reload() throws ConfigFailException {
        try {
            this.refresh();
            this.loadProfileList();
            this.loadCAList();
            this.loadCertStoreList();
            this.loadTrustedPolicies();
        }
        catch (Exception e) {
            throw new ConfigFailException("Reload content ", e.toString());
        }
    }

    private void loadProfileList() throws CSRProfileVerifyException, ProfileAlreadyExistException, ConfigFailException, XMLRecordDataException {
        NodeList parent = this.getNodeList(this.csrParentName);
        if (parent.getLength() == 0) {
            this.addEmptyElement(this.rootConfig, this.csrParentName);
            parent = this.getNodeList(this.csrParentName);
            if (parent.getLength() == 0) {
                throw new ConfigFailException("Load CSR list ", " It is no element " + this.csrParentName);
            }
        }
        if (parent.getLength() > 1) {
            throw new ConfigFailException("Load CSR list ", " Too many element of " + this.csrParentName);
        }
        CSRList pList = new CSRList();
        NodeList nodeList = parent.item(0).getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                pList.addProfile(new CSRProfile(nodeList.item(i)));
            }
            ++i;
        }
        this.csrList = pList;
    }

    public CertStoreList getCertStoreList() {
        return this.csl;
    }

    private void loadCertStoreList() throws ProfileAlreadyExistException, ConfigFailException, XMLRecordDataException {
        NodeList parent = this.getNodeList(this.cslParentName);
        if (parent.getLength() == 0) {
            this.addEmptyElement(this.rootConfig, this.cslParentName);
            parent = this.getNodeList(this.cslParentName);
            if (parent.getLength() == 0) {
                throw new ConfigFailException("Load Cert Store List ", " It is no element " + this.cslParentName);
            }
        }
        if (parent.getLength() > 1) {
            throw new ConfigFailException("Load Cert Store List ", " Too many element of " + this.cslParentName);
        }
        CertStoreList aList = new CertStoreList();
        NodeList nodeList = parent.item(0).getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                aList.setCertStoreProfile(new CertStoreProfile(nodeList.item(i)));
            }
            ++i;
        }
        this.csl = aList;
    }

    public CertStoreList addProfile(CertStoreProfile csp) throws ConfigFailException, ProfileAlreadyExistException {
        if (this.csl.indexOf(csp) > -1) {
            throw new ProfileAlreadyExistException(" Cert Store Provider No:" + csp.getCertStoreProviderNumber());
        }
        try {
            this.addElement(csp);
            this.apply();
        }
        catch (Exception e) {
            throw new ConfigFailException("Add new cert store profile  to xml ", e.toString());
        }
        return this.csl;
    }

    public CertStoreList addProfiles(CertStoreProfile[] csps) throws ConfigFailException, ProfileAlreadyExistException, XMLConfigFileManipulateException {
        if (csps.length > 1) {
            int i = 0;
            while (i < csps.length) {
                if (this.csl.indexOf(csps[i]) > -1) {
                    throw new ProfileAlreadyExistException(" Cert Store Provider No " + csps[i].getCertStoreProviderNumber());
                }
                try {
                    this.addElement(csps[i]);
                }
                catch (Exception e) {
                    throw new ConfigFailException("Add new profile to xml ", e.toString());
                }
                ++i;
            }
            try {
                this.apply();
            }
            catch (Exception e) {
                throw new XMLConfigFileManipulateException(e.toString());
            }
        }
        return this.csl;
    }

    public CertStoreList updateProfile(CertStoreProfile csp) throws ConfigFailException, ProfileNotFoundException {
        if (this.csl.indexOf(csp) < 0) {
            throw new ProfileNotFoundException(" cert store provider No:" + csp.getCertStoreProviderNumber());
        }
        try {
            this.updElement(csp);
            this.apply();
        }
        catch (Exception e) {
            throw new ConfigFailException("Update Cert Store Profile to config file ", e.toString());
        }
        return this.csl;
    }

    public CertStoreList dropProfile(CertStoreProfile csp) throws ConfigFailException, ProfileNotFoundException {
        if (this.csl.indexOf(csp) < 0) {
            throw new ProfileNotFoundException(" cert store provider No:" + csp.getCertStoreProviderNumber());
        }
        try {
            this.deleteElement(csp);
            this.apply();
        }
        catch (Exception e) {
            throw new ConfigFailException("Delete cert store profile from register ", e.toString());
        }
        return this.csl;
    }

    public CAList getCAList() {
        return this.caList;
    }

    private void loadCAList() throws ProfileAlreadyExistException, ConfigFailException, XMLRecordDataException {
        NodeList parent = this.getNodeList(this.caParentName);
        if (parent.getLength() == 0) {
            this.addEmptyElement(this.rootConfig, this.caParentName);
            parent = this.getNodeList(this.caParentName);
            if (parent.getLength() == 0) {
                throw new ConfigFailException("Load certificate authority  list ", " It is no element " + this.caParentName);
            }
        }
        if (parent.getLength() > 1) {
            throw new ConfigFailException("Load certificate authority list ", " Too many element of " + this.caParentName);
        }
        CAList aList = new CAList();
        NodeList nodeList = parent.item(0).getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                aList.updateAuthority(new Authority(nodeList.item(i), true));
            }
            ++i;
        }
        this.caList = aList;
    }

    public CAList addProfiles(Authority[] authorities) throws ConfigFailException, ProfileAlreadyExistException, XMLConfigFileManipulateException {
        if (authorities.length > 1) {
            int i = 0;
            while (i < authorities.length) {
                if (this.caList.indexOf(authorities[i]) > -1) {
                    throw new ProfileAlreadyExistException(authorities[i].getName());
                }
                try {
                    this.addElement(authorities[i]);
                }
                catch (Exception e) {
                    throw new ConfigFailException("Add new profile to xml ", e.toString());
                }
                ++i;
            }
            try {
                this.apply();
            }
            catch (Exception e) {
                throw new XMLConfigFileManipulateException(e.toString());
            }
        }
        return this.caList;
    }

    public CAList addProfile(Authority authority) throws ConfigFailException, ProfileAlreadyExistException {
        if (this.caList.indexOf(authority) > -1) {
            throw new ProfileAlreadyExistException(authority.getName());
        }
        try {
            this.addElement(authority);
            this.apply();
        }
        catch (Exception e) {
            throw new ConfigFailException("Add new authority to xml ", e.toString());
        }
        return this.caList;
    }

    public CAList updateProfile(Authority authority) throws ConfigFailException, ProfileNotFoundException {
        if (this.caList.indexOf(authority) < 0) {
            throw new ProfileNotFoundException(authority.getName());
        }
        try {
            this.updElement(authority);
            this.apply();
        }
        catch (Exception e) {
            throw new ConfigFailException("Update Profile to config file ", e.toString());
        }
        return this.caList;
    }

    public CAList dropProfile(Authority authority) throws ConfigFailException, ProfileNotFoundException {
        if (this.caList.indexOf(authority) < 0) {
            throw new ProfileNotFoundException(authority.getName());
        }
        try {
            this.deleteElement(authority);
            this.apply();
        }
        catch (Exception e) {
            throw new ConfigFailException("Delete authority from register ", e.toString());
        }
        return this.caList;
    }

    private void loadTrustedPolicies() throws XMLRecordDataException, ConfigFailException {
        NodeList parent = this.getNodeList(this.trusted);
        this.trustedPolicies.reset();
        this.trustedPolicies.setXMLRecord(parent.item(0));
    }

    public TrustedPolicies applyTrustedPolicies(TrustedPolicies policies) throws ConfigFailException {
        try {
            this.updElement(policies);
            this.apply();
        }
        catch (Exception e) {
            throw new ConfigFailException("Update trusted policies to config file ", e.toString());
        }
        return this.trustedPolicies;
    }

    public TrustedPolicies getTrustedPolicies() {
        return this.trustedPolicies;
    }
}

