/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.HouseKeeping;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;
import th.co.oga.security.pki.HouseKeeping.AgentProfile;
import th.co.oga.security.pki.HouseKeeping.CAList;
import th.co.oga.security.pki.HouseKeeping.CRLList;
import th.co.oga.security.pki.HouseKeeping.CRLRegister;
import th.co.oga.security.pki.HouseKeeping.CSRList;
import th.co.oga.security.pki.HouseKeeping.ConfigFailException;
import th.co.oga.security.pki.HouseKeeping.KeeperFatalException;
import th.co.oga.security.pki.HouseKeeping.RoomBuildException;
import th.co.oga.security.pki.HouseKeeping.RoomConfig;
import th.co.oga.security.pki.HouseKeeping.RoomConfigException;
import th.co.oga.security.pki.HouseKeeping.RoomType;
import th.co.oga.security.pki.HouseKeeping.RoomTypeNotSuppliedException;
import th.co.oga.security.pki.HouseKeeping.SaveHouse;
import th.co.oga.security.pki.HouseKeeping.TrustedPolicyTaker;
import th.co.oga.security.pki.Trusted.Authority;
import th.co.oga.security.pki.Trusted.ServiceName;
import th.co.oga.security.pki.Trusted.TrustedPolicies;
import th.co.oga.security.pki.service.RoomServiceDeamond;
import th.co.oga.security.pki.x.CRL.CRLProfile;
import th.co.oga.security.xml.XMLConfigEngineException;
import th.co.oga.security.xml.XMLConfigFileLoadException;
import th.co.oga.security.xml.XMLConfigFileNotFoundException;
import th.co.oga.security.xml.XMLRecordDataException;

public class RoomForService {
    private AgentProfile owner;
    private SaveHouse house;
    private String DoorState;
    private RoomType roomType;
    private RoomConfig config;
    private CSRList csrList;
    private CAList caList;
    private CRLRegister crlReg;
    private CRLList crlList;
    private RoomServiceDeamond service;

    protected RoomForService(SaveHouse house) {
        this.house = house;
    }

    protected void setOwner(AgentProfile agentProfile) throws KeeperFatalException, RoomConfigException {
        if (agentProfile == null) {
            throw new KeeperFatalException("Room", "Can not applied undefine agency .");
        }
        try {
            this.roomType = RoomType.getInstance(agentProfile.getAgentType());
            this.owner = agentProfile;
            this.load();
        }
        catch (RoomTypeNotSuppliedException e) {
            throw new KeeperFatalException("Room", e.toString());
        }
    }

    private String getHome() {
        if (this.roomType.getLocation().equalsIgnoreCase("I")) {
            return String.valueOf(this.house.getHome()) + this.house.getPathSeparator() + ".CryptOGA";
        }
        return String.valueOf(this.house.getRoomBase()) + this.house.getPathSeparator() + this.owner.getId();
    }

    public String getLogLocaltion() {
        return String.valueOf(this.getHome()) + this.house.getPathSeparator() + "logs";
    }

    public String getHelpLocaltion() {
        return String.valueOf(this.house.getRoomBase()) + this.house.getPathSeparator() + "help";
    }

    public String getOsHome() {
        return this.house.getHome();
    }

    private void load() throws RoomBuildException, RoomConfigException {
        boolean storeStatus = true;
        if (!this.house.isOpened()) {
            throw new RoomBuildException("House was not opened.");
        }
        String storeBase = this.getHome();
        File base = new File(storeBase);
        if (!base.exists()) {
            throw new RoomBuildException("Room is not build yet");
        }
        try {
            this.config = new RoomConfig(storeBase);
            this.csrList = this.config.getProfileList();
            this.caList = this.config.getCAList();
        }
        catch (XMLConfigFileNotFoundException e) {
            try {
                RoomConfig.initConfigFile(storeBase);
                this.config = new RoomConfig(storeBase);
                this.csrList = this.config.getProfileList();
                this.caList = this.config.getCAList();
            }
            catch (Exception e2) {
                throw new RoomConfigException(e2.toString());
            }
        }
        catch (ConfigFailException e) {
            throw new RoomConfigException(e.toString());
        }
        catch (XMLConfigFileLoadException e) {
            throw new RoomConfigException(e.toString());
        }
        catch (XMLRecordDataException e) {
            throw new RoomConfigException(e.toString());
        }
        catch (XMLConfigEngineException e) {
            throw new RoomConfigException(e.toString());
        }
        try {
            this.crlReg = new CRLRegister(storeBase);
            this.crlList = this.crlReg.getProfileList();
        }
        catch (XMLConfigFileNotFoundException e) {
            try {
                CRLRegister.initConfigFile(storeBase);
                this.crlReg = new CRLRegister(storeBase);
                this.csrList = this.config.getProfileList();
            }
            catch (Exception e2) {
                throw new RoomConfigException(e2.toString());
            }
        }
        catch (ConfigFailException e) {
            throw new RoomConfigException(e.toString());
        }
        catch (XMLConfigFileLoadException e) {
            throw new RoomConfigException(e.toString());
        }
        catch (XMLRecordDataException e) {
            throw new RoomConfigException(e.toString());
        }
        catch (XMLConfigEngineException e) {
            throw new RoomConfigException(e.toString());
        }
    }

    public Authority[] getAuthoritiesByService(ServiceName service) {
        ArrayList<Authority> ats = new ArrayList<Authority>();
        int i = 0;
        while (i < this.caList.size()) {
            Authority a = (Authority)this.caList.get(i);
            if (a.isServe(service)) {
                ats.add(a);
            }
            ++i;
        }
        Authority[] authorities = new Authority[ats.size()];
        int i2 = 0;
        while (i2 < ats.size()) {
            authorities[i2] = (Authority)ats.get(i2);
            ++i2;
        }
        return authorities;
    }

    public Authority getAuthority(String name) {
        return this.caList.getAuthority(name);
    }

    public CAList getCAList() {
        return this.caList;
    }

    public void setTrustedPolicies(TrustedPolicies policies) throws ConfigFailException {
        this.config.applyTrustedPolicies(policies);
    }

    public TrustedPolicies getTrustedPolicies() {
        return this.config.getTrustedPolicies();
    }

    public void keepCRL(CRLProfile crlProfile) throws ConfigFailException {
        X500Principal issueName = crlProfile.getIssueName();
        if (this.crlReg.isUpdate(crlProfile)) {
            this.crlList = this.crlReg.setProfile(crlProfile);
        }
    }

    public CRLList getCRLList() {
        return this.crlList;
    }

    public Iterator getToBeUpdateCRLAuthorities() {
        Authority[] auths = this.getAuthoritiesByService(ServiceName.CRL);
        ArrayList<Authority> list = new ArrayList<Authority>();
        Date date = Calendar.getInstance().getTime();
        int i = 0;
        while (i < auths.length) {
            CRLProfile crl = this.crlList.getProfile(auths[i].getSubjectName().toString());
            if (crl == null) {
                list.add(auths[i]);
            } else {
                try {
                    Date ld = crl.getLastUpdate();
                    if (ld == null) {
                        list.add(auths[i]);
                    } else if (ld.before(date)) {
                        list.add(auths[i]);
                    }
                }
                catch (ParseException e) {
                    list.add(auths[i]);
                }
            }
            ++i;
        }
        return list.iterator();
    }

    public AgentProfile getOwner() {
        return this.owner;
    }

    public TrustedPolicyTaker getTrustedPolicyTaker() {
        return new TrustedPolicyTaker(this);
    }

    public void close() {
    }
}

