/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.HouseKeeping;

import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Calendar;
import java.util.Locale;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.HouseKeeping.HouseOpenException;
import th.co.oga.security.pki.HouseKeeping.KeeperFatalException;
import th.co.oga.security.pki.service.RoomServiceDeamond;
import th.co.oga.security.utils.SysEnv;
import th.co.oga.security.xml.XMLRecord;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class SaveHouse
extends SysEnv
implements XMLRecord {
    private String ROOM_BASE_FOLDER = "rooms";
    private Node node;
    private String sysBase = "";
    private String sysVersion = "";
    private String sysTitle = "";
    private String sysSignature = "";
    private String sysLog = "";
    private boolean opened = false;
    private Locale thaiLocale = new Locale("th", "TH");
    private Locale standardLocale;
    private Locale defaultLocale = this.standardLocale = new Locale("en", "US");
    public static String AGENT_VERSION_1 = "Crypto Agent Version 1.0";
    public static String SERVER_VERSION_1 = "Crypto Server Version 1.0";
    public static RoomServiceDeamond roomService = null;
    private static Logger logger;

    protected SaveHouse() {
        Locale.setDefault(this.defaultLocale);
        this.sysBase = SaveHouse.getSysBase();
    }

    public String getRoomBase() {
        return String.valueOf(this.sysBase) + FS + this.ROOM_BASE_FOLDER;
    }

    public static String getSysBase() {
        if (SysEnv.CRYPTOGA_HOME != null) {
            return SysEnv.CRYPTOGA_HOME;
        }
        if (SysEnv.CRYPTOGA_HOME_ENV != null) {
            return SysEnv.CRYPTOGA_HOME_ENV;
        }
        if (SaveHouse.isOS(OS_WINDOWS)) {
            return "c:" + FS + "CryptOGA";
        }
        return String.valueOf(FS) + "usr" + FS + "CryptOGA";
    }

    public static boolean isWin32() {
        return SaveHouse.isOS(OS_WINDOWS);
    }

    public static void TraceInfo(String message) {
        if (logger == null) {
            String pattern = "%d\t%p\t%m\t%n";
            PatternLayout layout = new PatternLayout(pattern);
            try {
                logger = Logger.getLogger((String)"SaveHouse");
                logger.addAppender((Appender)new FileAppender((Layout)layout, String.valueOf(SaveHouse.getSysBase()) + FS + "bin" + FS + "SaveHouse.log", true));
            }
            catch (IOException e1) {
                logger = null;
            }
        }
        if (logger != null) {
            logger.info((Object)message);
        }
    }

    public String getVersion() {
        return this.sysVersion;
    }

    public String getTitle() {
        return this.sysTitle;
    }

    public Locale getLocale() {
        return this.defaultLocale;
    }

    public Calendar getCalendar() {
        return Calendar.getInstance(this.defaultLocale);
    }

    public Calendar getStandardCalendar() {
        return Calendar.getInstance(this.standardLocale);
    }

    public String getPathSeparator() {
        return FS;
    }

    public String getXMLRecord() {
        return null;
    }

    public Node getXMLNode(Document doc) {
        return null;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public boolean isXMLNode(Node node) throws XMLRecordDataException {
        return true;
    }

    public String getParentElementName() {
        return CryptOGAFormat.ROOT;
    }

    public String getElementName() {
        return CryptOGAFormat.SYSTEM;
    }

    public void setBase(String base) throws KeeperFatalException {
        File fbase = new File(base);
        if (!fbase.exists()) {
            throw new KeeperFatalException("SaveHouse", "Base is not existing");
        }
        this.sysBase = base;
    }

    public void setXMLRecord(Node node) throws XMLRecordDataException {
        this.node = node;
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            try {
                if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                    String nodeName = XMLUtils.nodeName(nodeList.item(i));
                    String nodeValue = XMLUtils.nodeValue(nodeList.item(i));
                    if (nodeName.equalsIgnoreCase(CryptOGAFormat.SYSTEM_TITLE)) {
                        this.sysTitle = nodeValue;
                    } else if (nodeName.equalsIgnoreCase(CryptOGAFormat.SYSTEM_BASE)) {
                        if (this.sysBase == null || this.sysBase.length() == 0) {
                            this.sysBase = nodeValue;
                        }
                    } else if (nodeName.equalsIgnoreCase(CryptOGAFormat.SYSTEM_VERSION)) {
                        this.sysVersion = nodeValue;
                    } else if (nodeName.equalsIgnoreCase(CryptOGAFormat.SYSTEM_LOG_FILE)) {
                        this.sysLog = nodeValue;
                    } else if (nodeName.equalsIgnoreCase(CryptOGAFormat.SYSTEM_SIGNATURE)) {
                        this.sysSignature = nodeValue;
                    }
                }
            }
            catch (NullPointerException e) {
                throw new XMLRecordDataException("House", " Null value was occure with element #" + i + nodeList.item(i).getNodeType());
            }
            ++i;
        }
    }

    public void setTitle(String title) {
        this.sysTitle = title;
    }

    public void setLocal(Locale locale) {
        this.defaultLocale = locale;
    }

    public void setVersion(String ver) {
        this.sysVersion = ver;
    }

    public void open() throws HouseOpenException {
        if (!this.opened) {
            File roomBaseFile;
            this.opened = true;
            File houseBaseFile = new File(this.sysBase);
            if (!houseBaseFile.exists()) {
                this.sysBase = this.getWorkingRoom();
            }
            if (!(roomBaseFile = new File(String.valueOf(this.sysBase) + FS + this.ROOM_BASE_FOLDER)).exists() && !roomBaseFile.mkdir()) {
                throw new HouseOpenException("Can not build room base folder.");
            }
        }
    }

    public String getSecureProviders() {
        String names = "";
        Provider[] pvds = Security.getProviders();
        int i = 0;
        while (i < pvds.length) {
            names = String.valueOf(names) + "\r\n Name :" + pvds[i].getName() + " Info :" + pvds[i].getInfo();
            ++i;
        }
        return names;
    }

    public static void setRoomService(RoomServiceDeamond service) {
        roomService = service;
    }
}

