/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.HouseKeeping;

import org.w3c.dom.NodeList;
import th.co.oga.security.pki.CryptOGAFormat;
import th.co.oga.security.pki.HouseKeeping.AgentList;
import th.co.oga.security.pki.HouseKeeping.AgentProfile;
import th.co.oga.security.pki.HouseKeeping.AgentProfileAlreadyExistException;
import th.co.oga.security.pki.HouseKeeping.AgentProfileNotFoundException;
import th.co.oga.security.pki.HouseKeeping.AgentProfileVerifyException;
import th.co.oga.security.pki.HouseKeeping.ConfigFailException;
import th.co.oga.security.pki.HouseKeeping.SaveHouse;
import th.co.oga.security.utils.SysEnv;
import th.co.oga.security.xml.Explorable;
import th.co.oga.security.xml.XMLConfigEngineException;
import th.co.oga.security.xml.XMLConfigFile;
import th.co.oga.security.xml.XMLConfigFileBackupException;
import th.co.oga.security.xml.XMLConfigFileLoadException;
import th.co.oga.security.xml.XMLConfigFileManipulateException;
import th.co.oga.security.xml.XMLConfigFileNotFoundException;
import th.co.oga.security.xml.XMLConfigFilePreException;
import th.co.oga.security.xml.XMLRecordDataException;
import th.co.oga.security.xml.XMLUtils;

public class SysConfig
extends XMLConfigFile
implements Explorable {
    private SaveHouse house = new SaveHouse();
    private AgentList agentList;

    protected SysConfig(String cryptOGAHome) throws ConfigFailException, XMLConfigFileNotFoundException, XMLConfigFileLoadException, XMLRecordDataException, XMLConfigEngineException {
        super(String.valueOf(cryptOGAHome) + SysEnv.FS + CryptOGAFormat.CONFIG_FILE_NAME);
        this.loadHouse();
        try {
            this.loadAgentList();
        }
        catch (Exception e) {
            throw new ConfigFailException("Load Agent List ", e.toString());
        }
    }

    public String explore() {
        String rtn = "";
        NodeList nl = super.getNodeList(CryptOGAFormat.ROOT);
        int c = 0;
        while (c < nl.getLength()) {
            rtn = String.valueOf(rtn) + XMLUtils.nodeExplorer(nl.item(c), "", 0);
            ++c;
        }
        return rtn;
    }

    protected AgentList getAgentList() {
        return this.agentList;
    }

    protected SaveHouse getHouse() {
        return this.house;
    }

    protected AgentList addAgent(AgentProfile[] agents) throws ConfigFailException, AgentProfileAlreadyExistException, AgentProfileVerifyException, XMLConfigFileManipulateException {
        if (agents.length > 1) {
            int i = 0;
            while (i < agents.length) {
                agents[i].verify(AgentProfile.MIDLE_LEVEL_VERIFY);
                if (this.agentList.indexOf(agents[i]) > -1) {
                    throw new AgentProfileAlreadyExistException(agents[i].getId());
                }
                try {
                    this.addElement(agents[i]);
                }
                catch (Exception e) {
                    throw new ConfigFailException("Add new profile to xml ", e.toString());
                }
                ++i;
            }
            try {
                this.apply();
            }
            catch (Exception e) {
                throw new XMLConfigFileManipulateException(e.toString());
            }
        }
        return this.agentList;
    }

    protected AgentList addAgent(AgentProfile agentProfile) throws ConfigFailException, XMLConfigFileManipulateException, AgentProfileAlreadyExistException, AgentProfileVerifyException {
        agentProfile.verify(AgentProfile.MIDLE_LEVEL_VERIFY);
        if (this.agentList.indexOf(agentProfile) > -1) {
            throw new AgentProfileAlreadyExistException(agentProfile.getId());
        }
        try {
            this.addElement(agentProfile);
            this.apply();
        }
        catch (Exception e) {
            throw new ConfigFailException("Add new profile to xml ", e.toString());
        }
        return this.agentList;
    }

    protected AgentList updateAgent(AgentProfile agentProfile) throws ConfigFailException, AgentProfileNotFoundException, AgentProfileVerifyException {
        agentProfile.verify(AgentProfile.MIDLE_LEVEL_VERIFY);
        if (this.agentList.indexOf(agentProfile) < 0) {
            throw new AgentProfileNotFoundException(agentProfile.getId());
        }
        try {
            this.updElement(agentProfile);
            this.apply();
        }
        catch (Exception e) {
            throw new ConfigFailException("Update agentProfile to config file ", e.toString());
        }
        return this.agentList;
    }

    protected AgentList dropAgent(AgentProfile agentProfile) throws ConfigFailException, AgentProfileNotFoundException, AgentProfileVerifyException {
        agentProfile.verify(AgentProfile.MIDLE_LEVEL_VERIFY);
        if (this.agentList.indexOf(agentProfile) < 0) {
            throw new AgentProfileNotFoundException(agentProfile.getId());
        }
        try {
            this.deleteElement(agentProfile);
            this.apply();
        }
        catch (Exception e) {
            throw new ConfigFailException("Delete profile from config file ", e.toString());
        }
        return this.agentList;
    }

    private void apply() throws XMLConfigFileManipulateException, ConfigFailException {
        try {
            String updNo = this.beginUpdate();
            this.flushUpdate(updNo);
        }
        catch (XMLConfigFileNotFoundException e) {
            throw new XMLConfigFileManipulateException(e.toString());
        }
        catch (XMLConfigFileBackupException e) {
            throw new XMLConfigFileManipulateException(e.toString());
        }
        catch (XMLConfigEngineException e) {
            throw new XMLConfigFileManipulateException(e.toString());
        }
        catch (XMLConfigFilePreException e) {
            throw new XMLConfigFileManipulateException(e.toString());
        }
        try {
            this.refresh();
            this.loadHouse();
            this.loadAgentList();
        }
        catch (Exception e) {
            throw new ConfigFailException("Reload content ", e.toString());
        }
    }

    public void reload() throws XMLConfigFileLoadException, XMLConfigFileNotFoundException {
        try {
            this.refresh();
            this.loadAgentList();
        }
        catch (Exception e) {
            throw new XMLConfigFileLoadException("Reload content ", e.toString());
        }
    }

    private void loadAgentList() throws AgentProfileVerifyException, AgentProfileAlreadyExistException, ConfigFailException, XMLRecordDataException {
        NodeList parent = this.getNodeList(CryptOGAFormat.PROFILE_PARENT);
        if (parent.getLength() == 0) {
            throw new ConfigFailException("Load agent list ", " Too many element of " + CryptOGAFormat.PROFILE_PARENT);
        }
        if (parent.getLength() > 1) {
            throw new ConfigFailException("Load agent list ", " It is no element " + CryptOGAFormat.PROFILE_PARENT);
        }
        AgentList agentList = new AgentList();
        NodeList nodeList = parent.item(0).getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (XMLUtils.nodeTypeIs((short)1, nodeList.item(i).getNodeType())) {
                agentList.addAgent(new AgentProfile(nodeList.item(i)));
            }
            ++i;
        }
        this.agentList = agentList;
    }

    private void loadHouse() throws XMLRecordDataException {
        NodeList nodeList = this.getNodeList(this.house.getElementName());
        this.house.setXMLRecord(nodeList.item(0));
    }
}

