/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.HouseKeeping;

import java.util.ArrayList;
import java.util.Iterator;
import th.co.oga.security.pki.Engine.SecureModule;
import th.co.oga.security.pki.Engine.SecureProviderName;
import th.co.oga.security.pki.HouseKeeping.AgentProfile;
import th.co.oga.security.pki.Operation.TokenOperatorOperationFailException;
import th.co.oga.security.pki.Operator.CryptoOperator;
import th.co.oga.security.pki.Operator.SecureStoreOperator;
import th.co.oga.security.pki.Operator.TokenOperator;
import th.co.oga.security.xml.Explorable;
import th.co.oga.security.xml.IndexList;

public class TokenList
extends ArrayList
implements Explorable {
    private IndexList idx = new IndexList();

    public TokenOperator addToken(SecureModule module) {
        int recNo = this.idx.recNo(module.getIDentifier());
        if (recNo > -1) {
            return (TokenOperator)this.get(recNo);
        }
        TokenOperator oper = SecureProviderName.getTokenOperator(module);
        this.add(oper);
        this.idx.addKey(module.getIDentifier());
        return oper;
    }

    public void setPasswordCalledBack(Object obj) throws TokenOperatorOperationFailException {
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            ((TokenOperator)itr.next()).setPasswordCalledBack(obj);
        }
    }

    public void wipe(SecureModule module) throws TokenOperatorOperationFailException {
        int recNo = this.idx.recNo(module.getIDentifier());
        if (recNo > -1) {
            ((TokenOperator)this.get(recNo)).wipe();
        }
    }

    public CryptoOperator getCeryptoOperator(SecureModule module) {
        int recNo = this.idx.recNo(module.getIDentifier());
        if (recNo > -1) {
            return ((TokenOperator)this.get(recNo)).getCeryptoOperator();
        }
        return null;
    }

    public void closeAllToken() throws TokenOperatorOperationFailException {
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            ((TokenOperator)itr.next()).close();
        }
    }

    public SecureStoreOperator getSecureStoreOperator(SecureModule module) {
        int recNo = this.idx.recNo(module.getIDentifier());
        if (recNo > -1) {
            return ((TokenOperator)this.get(recNo)).getStoreOperator();
        }
        return null;
    }

    public TokenOperator getTokenOperator(SecureModule module) {
        int recNo = this.idx.recNo(module.getIDentifier());
        if (recNo > -1) {
            return (TokenOperator)this.get(recNo);
        }
        return null;
    }

    public String explore() {
        String rtn = "";
        String key = "";
        int i = 0;
        while (i < this.size()) {
            key = (String)this.idx.get(i);
            AgentProfile a = (AgentProfile)this.get(i);
            rtn = String.valueOf(rtn) + "[ " + i + " | " + key + " ]" + a.toString() + "\n";
            ++i;
        }
        return rtn;
    }
}

