/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.HouseKeeping;

import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.HouseKeeping.CAList;
import th.co.oga.security.pki.HouseKeeping.Room;
import th.co.oga.security.pki.HouseKeeping.RoomForService;
import th.co.oga.security.pki.Trusted.Authority;
import th.co.oga.security.pki.Trusted.AuthorityNotRegisteredException;
import th.co.oga.security.pki.Trusted.AuthorityService;
import th.co.oga.security.pki.Trusted.DestinationDefineFailException;
import th.co.oga.security.pki.Trusted.ServiceName;
import th.co.oga.security.pki.Trusted.ServiceNotAvariableException;
import th.co.oga.security.pki.Trusted.TrustedPolicies;
import th.co.oga.security.pki.Trusted.TrustedPolicyNotEnableException;
import th.co.oga.security.pki.Trusted.TrustedService;

public class TrustedPolicyTaker {
    private CAList caList;
    private TrustedPolicies policy;
    private boolean CRLVerifyStatus = true;

    TrustedPolicyTaker(Room room) {
        this.policy = room.getTrustedPolicies();
        this.caList = room.getCAList();
    }

    TrustedPolicyTaker(RoomForService room) {
        this.policy = room.getTrustedPolicies();
        this.caList = room.getCAList();
    }

    public boolean isEnable() {
        return this.policy.isEnable();
    }

    public boolean isOCSPEnable() {
        return this.policy.getService(ServiceName.OCSP).isEnable();
    }

    public boolean isCRLEnable() {
        return this.policy.getService(ServiceName.CRL).isEnable();
    }

    public boolean isTimestampnable() {
        return this.policy.getService(ServiceName.TIMESTAMP).isEnable();
    }

    public boolean isCSREnable() {
        return this.policy.getService(ServiceName.CSR).isEnable();
    }

    public AuthorityService getOCSPAuthorityService(CertProfile cert) throws ASN1Exception {
        String authorityName = Authority.getAuthorityName(cert);
        Authority auth = this.caList.getAuthority(authorityName);
        if (auth != null) {
            return auth.findService(ServiceName.OCSP);
        }
        return null;
    }

    public AuthorityService getTimeStampAuthorityService(CertProfile cert) throws ASN1Exception {
        String authorityName = cert.getAuthorityName();
        Authority auth = this.caList.getAuthority(authorityName);
        if (auth != null) {
            return auth.findService(ServiceName.TIMESTAMP);
        }
        return null;
    }

    public AuthorityService getCRLAuthorityService(CertProfile cert) throws ASN1Exception {
        String authorityName = Authority.getAuthorityName(cert);
        Authority auth = this.caList.getAuthority(authorityName);
        if (auth != null) {
            return auth.findService(ServiceName.CRL);
        }
        return null;
    }

    public AuthorityService getCSRAuthorityService(CertProfile cert) throws ASN1Exception {
        String authorityName = Authority.getAuthorityName(cert);
        Authority auth = this.caList.getAuthority(authorityName);
        if (auth != null) {
            return auth.findService(ServiceName.CSR);
        }
        return null;
    }

    public AuthorityService getService(CertProfile cert, ServiceName service) throws DestinationDefineFailException {
        Authority auth;
        if (service.isFix()) {
            auth = this.getTrustedAuthority(service);
        } else {
            try {
                String authorityName = cert.getAuthorityName();
                auth = this.caList.getAuthority(authorityName);
                if (auth == null) {
                    throw new AuthorityNotRegisteredException(authorityName);
                }
            }
            catch (ASN1Exception e) {
                throw new DestinationDefineFailException(" error while define the name of authority.");
            }
        }
        AuthorityService as = auth.findService(service);
        if (as == null) {
            throw new ServiceNotAvariableException(auth, service);
        }
        return as;
    }

    public Authority getTrustedAuthority(ServiceName service) throws AuthorityNotRegisteredException, TrustedPolicyNotEnableException, ServiceNotAvariableException {
        if (this.policy.isEnable()) {
            TrustedService tservice = this.policy.getService(service);
            if (tservice.isEnable()) {
                Authority auth = this.caList.getAuthority(tservice.getAuthorityName());
                if (auth == null) {
                    throw new AuthorityNotRegisteredException(tservice.getAuthorityName());
                }
                return auth;
            }
            throw new ServiceNotAvariableException(service);
        }
        throw new TrustedPolicyNotEnableException();
    }
}

