/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operation;

import th.co.oga.security.pki.Certification.CertList;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertProfileNotFoundInListException;
import th.co.oga.security.pki.HouseKeeping.CertStoreParams;
import th.co.oga.security.pki.Operation.CertStoreAccessFailException;
import th.co.oga.security.pki.Operation.CertStoreStartFailException;
import th.co.oga.security.pki.Operation.CertStoreStopFailException;
import th.co.oga.security.pki.Operation.CertStoreUpdateFailException;
import th.co.oga.security.pki.Operation.CertificateFindingFailException;

public interface CertStoreOperation {
    public static final String JSS_CERT_STORE_NAME = "MozillaCertStore";
    public static final String MS_CERT_STORE_NAME = "MicrosoftCertStore";
    public static final String DB_CERT_STORE_NAME = "DatabaseCertStore";
    public static final String[] CERTSTORE_NAMES = new String[]{"MozillaCertStore", "MicrosoftCertStore", "DatabaseCertStore"};
    public static final int JSS_CERT_STORE_OPERATOR = 0;
    public static final int MS_CERT_STORE_OPERATOR = 1;
    public static final int DB_CERT_STORE_OPERATOR = 2;
    public static final String ALL_CERTIFICATE_GROUP = "AllCertificates";
    public static final String ROOT_CERTIFICATE_GROUP = "RootCertificates";
    public static final String TRUSTED_CERTIFICATE_GROUP = "TrustedCertificates";
    public static final String PROVIDER_CERTIFICATE_GROUP = "ProviderCertificates";

    public CertList getCerts(String var1) throws CertStoreAccessFailException;

    public CertList getCerts() throws CertStoreAccessFailException;

    public CertProfile findCertByCN(String var1) throws CertificateFindingFailException, CertProfileNotFoundInListException;

    public CertProfile findCertByEMail(String var1) throws CertificateFindingFailException, CertProfileNotFoundInListException;

    public CertProfile findCertBySubjectName(String var1) throws CertificateFindingFailException, CertProfileNotFoundInListException;

    public CertProfile findCertByIssuerAndSerialNumber(String var1, String var2) throws CertificateFindingFailException, CertProfileNotFoundInListException;

    public void setCerts(CertProfile[] var1) throws CertStoreUpdateFailException;

    public void setCert(CertProfile var1) throws CertStoreUpdateFailException;

    public void removeCert(CertProfile var1) throws CertStoreUpdateFailException;

    public void removeAllCerts() throws CertStoreUpdateFailException;

    public CertProfile getCertByRefID(String var1) throws CertificateFindingFailException;

    public void setCertByRefID(String var1, CertProfile var2) throws CertStoreUpdateFailException;

    public CertStoreParams getParameters();

    public void start(CertStoreParams var1) throws CertStoreStartFailException;

    public void stop() throws CertStoreStopFailException;

    public boolean isStart();

    public int getOperatorNumber();
}

