/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operation;

import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.util.List;
import th.co.oga.security.pki.Certification.CSRGeneration;
import th.co.oga.security.pki.Certification.CertChain;
import th.co.oga.security.pki.Certification.CertPackage;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertPackageTypeNotSupportException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.Certification.PFXProfile;
import th.co.oga.security.pki.EntryNotFoundException;
import th.co.oga.security.pki.HouseKeeping.CertStoreList;
import th.co.oga.security.pki.HouseKeeping.CertStoreProfile;
import th.co.oga.security.pki.Operation.AlgorithmOperation;
import th.co.oga.security.pki.Operation.PFXOperation;
import th.co.oga.security.pki.Operation.SecureStoreException;
import th.co.oga.security.pki.Operation.SecureStoreFindingFailException;
import th.co.oga.security.pki.Operation.SecureStoreSoftException;
import th.co.oga.security.pki.Operator.CryptoOperator;
import th.co.oga.security.pki.PinCode;

public interface SecureStoreOperation
extends AlgorithmOperation {
    public static final String CA_CERT_GROUP = "CA Certificate";
    public static final String USER_CERT_GROUP = "USER Certificate";
    public static final String TRUSTED_CERT_GROUP = "TRUSTED Certificate";

    public String getName();

    public CSRGeneration getCSRGenerator() throws SecureStoreException;

    public void importPrivateKey(byte[] var1, String var2) throws SecureStoreException, SecureStoreSoftException;

    public void importKeyPair(KeyPair var1) throws SecureStoreException, SecureStoreSoftException;

    public void importCertPackage(CertPackage var1) throws CertPackageException, CertPackageTypeNotSupportException;

    public void trustCert(CertProfile var1) throws Exception;

    public List getCertificates(String var1) throws SecureStoreException;

    public CertChain getCertChain(CertProfile var1) throws SecureStoreException;

    public CertChain getCertChain(CertProfile var1, CertProfile var2) throws SecureStoreException;

    public PFXProfile getPFX(CertProfile var1, PinCode var2) throws SecureStoreException;

    public byte[] getEncryptedPrivateKey(CertProfile var1, PinCode var2) throws SecureStoreException;

    public void deleteCertPackage(CertProfile var1) throws SecureStoreException;

    public void deletePrivateKey(KeyPair var1) throws SecureStoreException;

    public CertPackage getCertPackageInstance(String var1) throws CertPackageTypeNotSupportException, CertificateException, SecureStoreException;

    public CertProfile getIssuerCertificate(CertProfile var1) throws CertProfileException, IOException, CertificateException, EntryNotFoundException;

    public CertStoreProfile getCertStoreProfile();

    public void setCertStore(CertStoreProfile var1);

    public CertStoreList getSupportedCertStore();

    public void setCertStoreList(CertStoreList var1);

    public CryptoOperator getCryptoOperator();

    public PFXOperation getPKCS12Device() throws SecureStoreException;

    public String getKeyIdentifier(Key var1);

    public PrivateKey getPrivateKey(CertProfile var1) throws SecureStoreFindingFailException;

    public PrivateKey getJCAPrivateKey(CertProfile var1) throws SecureStoreException, SecureStoreFindingFailException;

    public String getInfos();
}

