/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.cert.CertificateEncodingException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.OIDs;

public class ASN1Adapter {
    private AlgorithmSupportTable algoTable;
    private AlgorithmSet digestAlgos;
    private AlgorithmSet signingAlgos;
    private AlgorithmSet dataEncryptAlgos;
    private AlgorithmSet keyWrapAlgos;
    private AlgorithmSet encryptAlgos;

    public ASN1Adapter(AlgorithmSupportTable algoTable) {
        this.algoTable = algoTable;
        this.digestAlgos = algoTable.getMessageDigestAlgorithm();
        this.signingAlgos = algoTable.getSignatureAlgorithm();
        this.dataEncryptAlgos = algoTable.getSymetricEncryptionAlgorithm();
        this.keyWrapAlgos = algoTable.getAsymetricEncryptionAlgorithm();
        this.encryptAlgos = algoTable.getEncryptionAlgorithm();
    }

    public static OBJECT_IDENTIFIER getObjID(String oid) {
        return new OBJECT_IDENTIFIER(oid);
    }

    public static String getOID(OBJECT_IDENTIFIER objID) {
        return OIDs.fromLongs(objID.getNumbers());
    }

    public static AlgorithmIdentifier getAlgoId(AlgorithmProfile alg, AlgorithmParameters params) throws InvalidBERException, IOException {
        return ASN1Adapter.getAlgoId(alg, params.getEncoded());
    }

    public static AlgorithmIdentifier getAlgoId(AlgorithmProfile alg, byte[] params) throws InvalidBERException, IOException {
        ANY param = null;
        if (params != null) {
            param = new ANY(params);
        }
        return new AlgorithmIdentifier(new OBJECT_IDENTIFIER(alg.getOID()), (ASN1Value)param);
    }

    public static AlgorithmIdentifier getAlgoId(AlgorithmProfile alg) {
        return new AlgorithmIdentifier(new OBJECT_IDENTIFIER(alg.getOID()), null);
    }

    public static byte[] getAlgorithmParamerters(AlgorithmIdentifier algId) {
        if (algId.getParameters() == null) {
            return null;
        }
        ANY param = (ANY)algId.getParameters();
        return param.getEncoded();
    }

    public static String getOID(AlgorithmIdentifier algID) {
        return OIDs.fromLongs(algID.getOID().getNumbers());
    }

    public static ASN1Value getCertificate(byte[] cer) throws ASN1Exception {
        try {
            return ASN1Util.decode((ASN1Template)Certificate.getTemplate(), (byte[])cer);
        }
        catch (Exception e) {
            throw new ASN1Exception("ASN.1 Operation fail, " + e.getMessage());
        }
    }

    public static ASN1Value getCertificate(CertProfile cer) throws ASN1Exception, CertificateEncodingException {
        return ASN1Adapter.getCertificate(cer.getX509Cert().getEncoded());
    }
}

