/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator;

import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSPEC;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSetName;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportException;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.Utils;

public class AlgorithmOperator
implements AlgorithmSPEC {
    protected AlgorithmSupportTable algoTable;

    protected AlgorithmOperator() {
    }

    public AlgorithmOperator(AlgorithmSupportTable algoTable) {
        this.algoTable = algoTable;
    }

    public AlgorithmProfile getAlgorithmByName(AlgorithmSetName setName, String algoName) throws AlgorithmSupportException {
        AlgorithmSet algoSet = this.algoTable.getAlgorithmSet(setName);
        return algoSet.findByName(algoName);
    }

    public AlgorithmProfile getAlgorithmByOID(AlgorithmSetName setName, String oid) throws AlgorithmSupportException {
        AlgorithmSet algoSet = this.algoTable.getAlgorithmSet(setName);
        return algoSet.findByOID(oid);
    }

    public AlgorithmSupportTable getSupportAlgorithm() {
        return this.algoTable;
    }

    public AlgorithmSet getAlgorithmSet(AlgorithmSetName setName) throws AlgorithmSupportException {
        return this.algoTable.getAlgorithmSet(setName);
    }

    public AlgorithmProfile getDigestAlgorithm(String algName) throws AlgorithmSupportException {
        return this.algoTable.getMessageDigestAlgorithm().findByName(algName);
    }

    public AlgorithmProfile getEncryptionAlgorithmByOID(String oid) throws AlgorithmSupportException {
        return this.algoTable.getSymetricEncryptionAlgorithm().findByOID(oid);
    }

    public AlgorithmProfile getAsymetricEncryptionAlgorithmByName(String name) throws AlgorithmSupportException {
        return this.algoTable.getAsymetricEncryptionAlgorithm().findByName(name);
    }

    public AlgorithmProfile getAsymetricEncryptionAlgorithmByOID(long[] oid) throws AlgorithmSupportException {
        return this.algoTable.getAsymetricEncryptionAlgorithm().findByOID(oid);
    }

    public AlgorithmProfile getSignatureAlgorithmByOID(long[] id) throws AlgorithmSupportException {
        return this.algoTable.getSignatureAlgorithm().findByOID(id);
    }

    public int getKeyStrength(AlgorithmProfile alg) {
        String keyAlgName = alg.getKeyAlgorithmName();
        String algName = alg.getName();
        int keyStrength = 0;
        keyStrength = keyAlgName.equalsIgnoreCase("DES") ? 56 : (keyAlgName.equalsIgnoreCase("BW") ? 32 : (keyAlgName.equalsIgnoreCase("DESEDE") ? 168 : (keyAlgName.equalsIgnoreCase("AES") ? (algName.indexOf("256") > -1 ? 256 : (algName.indexOf("192") > -1 ? 192 : 256)) : (keyAlgName.equalsIgnoreCase("RC4") ? (algName.indexOf("128") > -1 ? 128 : (algName.indexOf("40") > -1 ? 40 : 16)) : (keyAlgName.equalsIgnoreCase("RC2") ? (algName.indexOf("128") > -1 ? 128 : (algName.indexOf("40") > -1 ? 40 : 16)) : 8)))));
        return keyStrength;
    }

    public int getBlockSize(AlgorithmProfile alg) {
        String keyAlgName = alg.getKeyAlgorithmName();
        String algName = alg.getName();
        int len = 0;
        len = keyAlgName.equalsIgnoreCase("DES") ? 8 : (keyAlgName.equalsIgnoreCase("DESEDE") ? 8 : (keyAlgName.equalsIgnoreCase("AES") ? 16 : (keyAlgName.equalsIgnoreCase("RC4") ? 1 : (keyAlgName.equalsIgnoreCase("RC2") ? 8 : 8))));
        return len;
    }

    public int getSaltLength(AlgorithmProfile alg) {
        String keyAlgName = alg.getEncryptionAlgorithmName();
        String algName = alg.getName();
        int len = 0;
        len = keyAlgName.equalsIgnoreCase("DES") ? 8 : (keyAlgName.equalsIgnoreCase("DESEDE") ? 20 : (keyAlgName.equalsIgnoreCase("RC4") ? 20 : (keyAlgName.equalsIgnoreCase("RC2") ? 20 : 8)));
        return len;
    }

    public String getKeySizesSpec(AlgorithmProfile alg) {
        String keyAlgName = alg.getEncryptionAlgorithmName();
        String algName = alg.getName();
        if (keyAlgName.equalsIgnoreCase("DES")) {
            return "FIX:56";
        }
        if (keyAlgName.equalsIgnoreCase("DESEDE")) {
            return "FIX:168";
        }
        if (keyAlgName.equalsIgnoreCase("AES")) {
            return "STEP:128,192,256";
        }
        if (keyAlgName.equalsIgnoreCase("RC2")) {
            return "BETWEEN:8,1024";
        }
        return "NA";
    }

    public boolean verifyKeyLength(AlgorithmProfile alg, int size) {
        String sizes = this.getKeySizesSpec(alg);
        String[] part = sizes.split(":");
        String method = part[0];
        if (method.compareTo("NA") == 0) {
            return true;
        }
        String value = part[1];
        if (method.compareTo("BETWEEN") == 0) {
            String[] values = value.split(",");
            int min = new Integer(values[0]);
            int max = new Integer(values[1]);
            return min <= size && size <= max;
        }
        return value.indexOf(size) > -1;
    }

    public AlgorithmParameterSpec getParameterSpec(AlgorithmProfile alg, AlgorithmParameters params) throws InvalidParameterSpecException, AlgorithmSupportException {
        String encName = alg.getEncryptionAlgorithmName();
        String encMode = alg.getEncryptionMode();
        if (alg.isPBE()) {
            return params.getParameterSpec(PBEParameterSpec.class);
        }
        if (encName.indexOf("DES") > -1) {
            return params.getParameterSpec(IvParameterSpec.class);
        }
        if (encName.indexOf("AES") > -1) {
            return params.getParameterSpec(IvParameterSpec.class);
        }
        if (encName.indexOf("RC2") > -1) {
            return params.getParameterSpec(RC2ParameterSpec.class);
        }
        if (encName.indexOf("RC5") > -1) {
            return params.getParameterSpec(RC5ParameterSpec.class);
        }
        throw new AlgorithmSupportException("Algorithm Parameter Spec generate not support algorithm " + alg.getName());
    }

    public AlgorithmParameterSpec getParameterSpec(AlgorithmProfile alg, SecureRandom rand, String password) throws AlgorithmSupportException {
        byte[] iv;
        rand.setSeed(Utils.genTimeSeed());
        String encName = alg.getEncryptionAlgorithmName();
        String encMode = alg.getEncryptionMode();
        if (alg.isPBE()) {
            byte[] salt = new byte[this.getSaltLength(alg)];
            rand.nextBytes(salt);
            return new PBEParameterSpec(salt, 1);
        }
        if (password == null) {
            iv = new byte[this.getBlockSize(alg)];
            rand.nextBytes(iv);
        } else {
            int len = this.getBlockSize(alg);
            if (len > password.length()) {
                int i = password.length();
                while (i < len) {
                    password = String.valueOf(password) + " ";
                    ++i;
                }
            }
            if (password.length() > len) {
                password = password.substring(0, len);
            }
            iv = password.getBytes();
        }
        if ("DES,DESede,AES".indexOf(encName) > -1) {
            return new IvParameterSpec(iv);
        }
        if (encName.indexOf("RC2") > -1) {
            return new RC2ParameterSpec(this.getKeyStrength(alg), iv);
        }
        if (encName.indexOf("RC5") > -1) {
            return new RC5ParameterSpec(0, 2, 64, iv);
        }
        throw new AlgorithmSupportException("Algorithm Parameter Spec generate not support algorithm " + alg.getName());
    }

    public KeySpec genSecretKeySpec(AlgorithmProfile alg, SecureRandom rand, String password) throws InvalidKeyException, AlgorithmSupportException {
        byte[] iv;
        rand.setSeed(Utils.genTimeSeed());
        String keyAlgName = alg.getKeyAlgorithmName();
        if (alg.isPBE()) {
            byte[] salt = new byte[this.getSaltLength(alg)];
            rand.nextBytes(salt);
            return new PBEKeySpec(password.toCharArray(), salt, 1, this.getKeyStrength(alg));
        }
        if (password == null) {
            iv = new byte[this.getKeyStrength(alg)];
            rand.nextBytes(iv);
        } else {
            int len = this.getKeyStrength(alg);
            int i = password.length();
            while (i < len) {
                password = String.valueOf(password) + " ";
                ++i;
            }
            iv = password.getBytes();
        }
        if (keyAlgName.equalsIgnoreCase("DES")) {
            return new DESKeySpec(iv);
        }
        if (keyAlgName.equalsIgnoreCase("DESede")) {
            return new DESedeKeySpec(iv);
        }
        if (keyAlgName.equalsIgnoreCase("AES")) {
            return new SecretKeySpec(iv, keyAlgName);
        }
        if (keyAlgName.equalsIgnoreCase("RC4")) {
            return new SecretKeySpec(iv, 0, this.getKeyStrength(alg), keyAlgName);
        }
        if (keyAlgName.equalsIgnoreCase("RC5")) {
            return new SecretKeySpec(iv, 0, this.getKeyStrength(alg), keyAlgName);
        }
        if (keyAlgName.equalsIgnoreCase("RC2")) {
            return new SecretKeySpec(iv, 0, this.getKeyStrength(alg), keyAlgName);
        }
        throw new AlgorithmSupportException("Key Spec generation not support algorithm " + keyAlgName);
    }

    public SecretKeySpec genSecretKeySpec(AlgorithmProfile alg, String password) throws InvalidKeyException, AlgorithmSupportException {
        String keyAlgName = alg.getKeyAlgorithmName();
        byte[] iv = password.getBytes();
        if (keyAlgName.equalsIgnoreCase("DES")) {
            return new SecretKeySpec(iv, keyAlgName);
        }
        if (keyAlgName.equalsIgnoreCase("DESede")) {
            return new SecretKeySpec(iv, keyAlgName);
        }
        if (keyAlgName.equalsIgnoreCase("AES")) {
            return new SecretKeySpec(iv, keyAlgName);
        }
        if (keyAlgName.equalsIgnoreCase("RC4")) {
            return new SecretKeySpec(iv, 0, this.getKeyStrength(alg), keyAlgName);
        }
        if (keyAlgName.equalsIgnoreCase("RC5")) {
            return new SecretKeySpec(iv, 0, this.getKeyStrength(alg), keyAlgName);
        }
        if (keyAlgName.equalsIgnoreCase("RC2")) {
            return new SecretKeySpec(iv, 0, this.getKeyStrength(alg), keyAlgName);
        }
        throw new AlgorithmSupportException("Secret Key Spec generation not support algorithm " + keyAlgName);
    }
}

