/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.Assembla;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import se.assembla.jce.provider.ms.MSProvider;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertList;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertProfileNotFoundInListException;
import th.co.oga.security.pki.Certification.InternalCertProfile;
import th.co.oga.security.pki.HouseKeeping.CertStoreParams;
import th.co.oga.security.pki.Operation.CertStoreAccessFailException;
import th.co.oga.security.pki.Operation.CertStoreConstructionFailException;
import th.co.oga.security.pki.Operation.CertStoreOperation;
import th.co.oga.security.pki.Operation.CertStoreStartFailException;
import th.co.oga.security.pki.Operation.CertStoreStopFailException;
import th.co.oga.security.pki.Operation.CertStoreUpdateFailException;
import th.co.oga.security.pki.Operation.CertificateFindingFailException;

public class AJCE_CertStore
implements CertStoreOperation {
    private static CertProfile certProfile;
    private static CertList certList;
    private static KeyStore keyStore;
    private String PERSONAL_CERT_GROUP = "MY";
    private String OTHER_PEOPLE_CERT_GROUP = "ADDRESSBOOK";
    private String SUB_CA_CERT_GROUP = "CA";
    private String ROOT_CERT_GROUP = "ROOT";

    public AJCE_CertStore() throws NoSuchProviderException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Security.insertProviderAt((Provider)new MSProvider(), 2);
        keyStore = KeyStore.getInstance("msks", "assembla");
        keyStore.load(null, null);
    }

    public void setParameters(Properties params) {
    }

    public CertList getCerts() throws CertStoreAccessFailException {
        return this.getCerts("AllCertificates");
    }

    public CertList getCerts(String certGroup) throws CertStoreAccessFailException {
        certList = new CertList();
        try {
            CertStore certStore;
            if (certGroup.equals("TrustedCertificates") || certGroup.equals("AllCertificates")) {
                certStore = CertStore.getInstance(this.OTHER_PEOPLE_CERT_GROUP, (CertStoreParameters)new CollectionCertStoreParameters(), "assembla");
                this.addCertToCertList(certList, certStore, "TrustedCertificates");
            }
            if (certGroup.equals("RootCertificates") || certGroup.equals("AllCertificates")) {
                certStore = CertStore.getInstance(this.ROOT_CERT_GROUP, (CertStoreParameters)new CollectionCertStoreParameters(), "assembla");
                this.addCertToCertList(certList, certStore, "RootCertificates");
                CertStore certStore1 = CertStore.getInstance(this.SUB_CA_CERT_GROUP, (CertStoreParameters)new CollectionCertStoreParameters(), "assembla");
                this.addCertToCertList(certList, certStore1, "RootCertificates");
            }
            if (certGroup.equals("AllCertificates")) {
                certStore = CertStore.getInstance(this.PERSONAL_CERT_GROUP, (CertStoreParameters)new CollectionCertStoreParameters(), "assembla");
                this.addCertToCertList(certList, certStore, this.PERSONAL_CERT_GROUP);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return certList;
    }

    private String getAlias(X509Certificate cert) throws KeyStoreException {
        return keyStore.getCertificateAlias(cert);
    }

    private void addCertToCertList(CertList cl, CertStore cs, String group) throws CertStoreException, CertificateException, KeyStoreException {
        Collection<? extends Certificate> co = cs.getCertificates(null);
        System.out.println("Foud " + co.size() + " certificate(s) in " + group + " certificate store.");
        for (X509Certificate x509Certificate : co) {
            InternalCertProfile icp = new InternalCertProfile(x509Certificate, this.getAlias(x509Certificate));
            cl.setCert(icp);
        }
    }

    public CertProfile findCertByCN(String cn) throws CertificateFindingFailException, CertProfileNotFoundInListException {
        certProfile = certList.getCertByCN(cn);
        return certProfile;
    }

    public CertProfile findCertByEMail(String emailAddress) throws CertificateFindingFailException, CertProfileNotFoundInListException {
        certProfile = certList.getCertByEMail(emailAddress);
        return certProfile;
    }

    public CertProfile findCertBySubjectName(String subjectName) throws CertificateFindingFailException, CertProfileNotFoundInListException {
        certProfile = certList.getCertBySubjectName(subjectName);
        return certProfile;
    }

    public CertProfile findCertByIssuerAndSerialNumber(String issuerSubjectName, String sn) throws CertificateFindingFailException, CertProfileNotFoundInListException {
        certProfile = certList.getCertByIssuerAndSerialNumber(String.valueOf(issuerSubjectName) + sn);
        return certProfile;
    }

    public void setCerts(CertProfile[] cert) throws CertStoreUpdateFailException {
        X509Certificate xcert = null;
        int i = 0;
        while (i < cert.length) {
            xcert = cert[i].getX509Cert();
            try {
                if (!cert[i].isCA()) {
                    keyStore.setCertificateEntry(null, xcert);
                }
            }
            catch (ASN1Exception e1) {
                e1.printStackTrace();
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void setCert(CertProfile cert) throws CertStoreUpdateFailException {
        X509Certificate xcert = cert.getX509Cert();
        try {
            keyStore.setCertificateEntry(null, xcert);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
    }

    public void removeCert(CertProfile cert) throws CertStoreUpdateFailException {
        X509Certificate xcert = cert.getX509Cert();
        try {
            String alias = keyStore.getCertificateAlias(xcert);
            keyStore.deleteEntry(alias);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
    }

    public void removeAllCerts() throws CertStoreUpdateFailException {
        String alias = null;
        try {
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                alias = e.nextElement();
                System.out.println("show: " + alias);
                keyStore.deleteEntry(alias);
            }
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
    }

    public CertProfile getCertByRefID(String refNo) throws CertificateFindingFailException {
        return null;
    }

    public void setCertByRefID(String refNo, CertProfile cert) throws CertStoreUpdateFailException {
    }

    public CertStoreParams getParameters() {
        return new CertStoreParams();
    }

    public void start(CertStoreParams params) throws CertStoreStartFailException {
    }

    public void stop() throws CertStoreStopFailException {
    }

    public int getOperatorNumber() {
        return 1;
    }

    public static CertStoreOperation getInstance() throws CertStoreConstructionFailException {
        try {
            AJCE_CertStore cso = new AJCE_CertStore();
            return cso;
        }
        catch (Exception e) {
            throw new CertStoreConstructionFailException("MicrosoftCertStore", " error while access to microsoft key store, " + e.toString());
        }
    }

    public boolean isStart() {
        return true;
    }
}

