/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator;

import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.Operation.CryptoOperation;
import th.co.oga.security.pki.Operation.KeyGenerateFailException;
import th.co.oga.security.pki.Operator.AlgorithmOperator;

public class CryptoOperator
extends AlgorithmOperator
implements CryptoOperation {
    private Provider secureProvider;
    protected String prngName = "SHA1PRNG";

    public CryptoOperator(Provider provider, AlgorithmSupportTable algoTable) {
        super(algoTable);
        this.secureProvider = provider;
    }

    public Provider getSecureProvider() {
        return this.secureProvider;
    }

    public AlgorithmParameters getAlgorithmParameters(AlgorithmProfile algo) throws NoSuchAlgorithmException {
        return AlgorithmParameters.getInstance(algo.getKeyAlgorithmName(), this.secureProvider);
    }

    public KeyPairGenerator getKeyPairGenerator(AlgorithmProfile algo) throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance(algo.getAlgorithmName(), this.secureProvider);
    }

    public MessageDigest getMessageDigest(AlgorithmProfile algo) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(algo.getMessageDigestAlgorithmName(), this.secureProvider);
    }

    public SecureRandom getSecureRandom() throws NoSuchAlgorithmException {
        return SecureRandom.getInstance(this.prngName, this.secureProvider);
    }

    public KeyGenerator getKeyGenerator(AlgorithmProfile algo) throws NoSuchAlgorithmException {
        return KeyGenerator.getInstance(algo.getKeyAlgorithmName(), this.secureProvider);
    }

    public KeyFactory getKeyFactory(AlgorithmProfile algo) throws NoSuchAlgorithmException {
        return KeyFactory.getInstance(algo.getKeyAlgorithmName(), this.secureProvider);
    }

    public SecretKeyFactory getSecretKeyFactory(AlgorithmProfile algo) throws NoSuchAlgorithmException {
        return SecretKeyFactory.getInstance(algo.getKeyAlgorithmName(), this.secureProvider);
    }

    public Cipher getCipher(AlgorithmProfile algo) throws NoSuchAlgorithmException, NoSuchPaddingException {
        return Cipher.getInstance(algo.getTransform(), this.secureProvider);
    }

    public Signature getSignature(AlgorithmProfile algo) throws NoSuchAlgorithmException {
        return Signature.getInstance(algo.getAlgorithmName(), this.secureProvider);
    }

    public PublicKey retrustedPublicKey(PublicKey publ) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return publ;
    }

    public String getKeySpecSupportAlgos() {
        return "DES,PBE";
    }

    public String getCipherParamSupportAlgos() {
        return "RC2,RC5,DES,DESede";
    }

    public String getKeyFactorySupportAlgos() {
        return "PBE,DES";
    }

    public String getKeyGeneratorSupportAlgos() {
        return "PBE,RC2,RC5,DES,DESede";
    }

    public String getSecretKeyFactorySupportAlgos() {
        return "PBE,RC2,RC5,DES,DESede";
    }

    public String getKeyGenParamSupportAlgos() {
        return "PBE,RC2,RC5,DES,DESede";
    }

    public SecretKey genSecretKey(AlgorithmProfile alg, String password) throws KeyGenerateFailException {
        String keyFactSupport = this.getSecretKeyFactorySupportAlgos();
        String keySpecSupport = this.getKeySpecSupportAlgos();
        String keyGenSupport = this.getKeyGeneratorSupportAlgos();
        String keyGenParamSupport = this.getKeyGenParamSupportAlgos();
        String keyAlgName = alg.getKeyAlgorithmName();
        try {
            SecretKey key = null;
            SecureRandom srand = this.getSecureRandom();
            if (keyGenSupport.indexOf(keyAlgName) > -1) {
                KeyGenerator keyGen = this.getKeyGenerator(alg);
                if (keyGenParamSupport.indexOf(keyAlgName) > -1) {
                    AlgorithmParameterSpec paramSpec = this.getParameterSpec(alg, srand, password);
                    if (paramSpec != null) {
                        keyGen.init(paramSpec);
                    }
                } else {
                    keyGen.init(this.getKeyStrength(alg));
                }
                key = keyGen.generateKey();
            } else if (keyFactSupport.indexOf(keyAlgName) > -1) {
                KeySpec keySpec = this.genSecretKeySpec(alg, srand, password);
                SecretKeyFactory keyFact = this.getSecretKeyFactory(alg);
                key = keyFact.generateSecret(keySpec);
            } else if (password != null) {
                SecretKeySpec sks = new SecretKeySpec(password.getBytes(), alg.getKeyAlgorithmName());
                key = sks;
            } else {
                KeyGenerator keyGen = this.getKeyGenerator(alg);
                keyGen.init(this.getKeyStrength(alg), srand);
                key = keyGen.generateKey();
            }
            if (key != null) {
                return key;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KeyGenerateFailException(this.getSecureProvider().getName(), e.toString());
        }
        throw new KeyGenerateFailException(this.getSecureProvider().getName(), String.valueOf(keyAlgName) + "  not in support list");
    }

    public SecretKey getSecretKey(AlgorithmProfile algorithm, byte[] key) throws NoSuchAlgorithmException, KeyGenerateFailException {
        SecretKeyFactory skf = this.getSecretKeyFactory(algorithm);
        SecretKeySpec sks = new SecretKeySpec(key, algorithm.getKeyAlgorithmName());
        try {
            return skf.generateSecret(sks);
        }
        catch (Exception e) {
            throw new KeyGenerateFailException(this.getSecureProvider().getName(), e.getMessage());
        }
    }
}

