/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import th.co.oga.security.pki.ASN1Exception;
import th.co.oga.security.pki.Certification.CertList;
import th.co.oga.security.pki.Certification.CertPackageException;
import th.co.oga.security.pki.Certification.CertProfile;
import th.co.oga.security.pki.Certification.CertProfileException;
import th.co.oga.security.pki.Certification.CertProfileNotFoundInListException;
import th.co.oga.security.pki.Certification.InternalCertProfile;
import th.co.oga.security.pki.DatabaseParameters;
import th.co.oga.security.pki.HouseKeeping.CertStoreParams;
import th.co.oga.security.pki.HouseKeeping.SaveHouse;
import th.co.oga.security.pki.Operation.CertStoreAccessFailException;
import th.co.oga.security.pki.Operation.CertStoreLoadingFailException;
import th.co.oga.security.pki.Operation.CertStoreOperation;
import th.co.oga.security.pki.Operation.CertStoreStartFailException;
import th.co.oga.security.pki.Operation.CertStoreStopFailException;
import th.co.oga.security.pki.Operation.CertStoreUpdateFailException;
import th.co.oga.security.pki.Operation.CertificateFindingFailException;
import th.co.oga.security.pki.service.DBCertStoreUpdater;

public class DBCertStore
implements CertStoreOperation {
    private DatabaseParameters params = new DatabaseParameters();
    private Connection connect = null;
    private int group = 2;
    private boolean started = false;
    private String dbName = "NA";
    public static String SEACH_BY_EMAIL = "emailAddress";
    public static String SEACH_BY_CN = "CommonName";
    public static String SEACH_BY_SUBJECT = "subjectName";
    public static String SEACH_BY_ISSUER_SN = "CertID";
    public static int ALL_CERT_GROUP = 0;
    public static int ROOT_CERT_GROUP = 1;
    public static int TRUSTED_CERT_GROUP = 2;
    public static int PROVIDER_CERT_GROUP = 3;
    private CertList certList = new CertList();
    private CertList rootCertList = new CertList();
    private CertList trustCertList = new CertList();
    private CertList pvdCertList = new CertList();
    private HashMap certRef = new HashMap();
    private DBCertStoreUpdater certStoreReloader = new DBCertStoreUpdater(this);
    private Logger logger;
    public static int READY_PROFILE = 0;
    public static int TOBE_INSERT_PROFILE = 1;
    public static int TOBE_UPDATED_PROFILE = 2;
    public static int TOBE_DELETEED_PROFILE = 3;

    public DBCertStore() {
        try {
            String pattern = "%d\t%p\t%m\t%n";
            PatternLayout layout = new PatternLayout(pattern);
            this.logger = Logger.getLogger((String)"DBCertStore");
            this.logger.addAppender((Appender)new FileAppender((Layout)layout, String.valueOf(SaveHouse.getSysBase()) + SaveHouse.FS + "bin" + SaveHouse.FS + "db_cert_store.log", true));
        }
        catch (IOException e1) {
            SaveHouse.TraceInfo("Can not allocate log location for db cert store I O Error");
        }
    }

    public Connection getConnection() {
        return this.connect;
    }

    public void setGroup(String group) {
        this.group = this.getCertGroupID(group);
        if (this.group == 0) {
            this.group = 2;
        }
    }

    private void traceInfo(String message) {
        if (this.logger != null) {
            this.logger.info((Object)message);
        }
    }

    public CertList getCerts(String certGroup) throws CertStoreAccessFailException {
        int grp = this.getCertGroupID(certGroup);
        if (grp == ALL_CERT_GROUP) {
            return this.certList;
        }
        if (grp == ROOT_CERT_GROUP) {
            return this.rootCertList;
        }
        if (grp == TRUSTED_CERT_GROUP) {
            return this.trustCertList;
        }
        return this.pvdCertList;
    }

    public CertList getCerts() throws CertStoreAccessFailException {
        return this.getCerts("AllCertificates");
    }

    public CertProfile findCertByCN(String cn) throws CertificateFindingFailException, CertProfileNotFoundInListException {
        return this.certList.getCertByCN(cn);
    }

    public CertProfile findCertByEMail(String emailAddress) throws CertificateFindingFailException, CertProfileNotFoundInListException {
        return this.certList.getCertByEMail(emailAddress);
    }

    public CertProfile findCertBySubjectName(String subjectName) throws CertificateFindingFailException, CertProfileNotFoundInListException {
        return this.certList.getCertBySubjectName(subjectName);
    }

    public CertProfile findCertByIssuerAndSerialNumber(String issuerSubjectName, String sn) throws CertificateFindingFailException, CertProfileNotFoundInListException {
        return this.certList.getCertByIssuerAndSerialNumber(String.valueOf(issuerSubjectName) + sn);
    }

    public void setCerts(CertProfile[] cert) throws CertStoreUpdateFailException {
        int i = 0;
        while (i < cert.length) {
            this.setCert(cert[i]);
            ++i;
        }
    }

    public void setCert(CertProfile cert) throws CertStoreUpdateFailException {
        InternalCertProfile icp = this.certList.getCert(cert);
        if (icp == null) {
            DBCertProfile dcp = new DBCertProfile(cert);
            dcp.state = TOBE_INSERT_PROFILE;
            try {
                this.certList.setCert(dcp);
            }
            catch (CertProfileException e) {
                throw new CertStoreUpdateFailException("Can not add new certificate profile to TBU list");
            }
        }
    }

    public void removeCert(CertProfile cert) throws CertStoreUpdateFailException {
        DBCertProfile dcp = (DBCertProfile)this.certList.getCert(cert);
        if (dcp != null) {
            if (dcp.state == READY_PROFILE) {
                dcp.state = TOBE_DELETEED_PROFILE;
            } else {
                throw new CertStoreUpdateFailException("Can not update certificate profile was already in TBU list");
            }
        }
    }

    public void removeAllCerts() throws CertStoreUpdateFailException {
        Iterator certs = this.certList.getIterator();
        while (certs.hasNext()) {
            DBCertProfile dcp = (DBCertProfile)certs.next();
            if (dcp.state != READY_PROFILE) continue;
            dcp.state = TOBE_DELETEED_PROFILE;
        }
    }

    public CertProfile getCertByRefID(String refNo) throws CertificateFindingFailException {
        String sql = "SELECT  A.Cert as cert, B.Priority, B.Status FROM Certification A, CertMapping B  WHERE A.CertId = B.CertId AND B.Ref_ID='" + refNo + "'";
        try {
            return this.getCertFromDB(sql);
        }
        catch (CertificateException e) {
            throw new CertificateFindingFailException("Certificate error", e.toString());
        }
        catch (IOException e) {
            throw new CertificateFindingFailException("Connection error", e.toString());
        }
        catch (SQLException e) {
            throw new CertificateFindingFailException("Database error", e.toString());
        }
    }

    public void setCertByRefID(String refNo, CertProfile cert) throws CertStoreUpdateFailException {
        DBCertProfile dcp = (DBCertProfile)this.certList.getCert(cert);
        if (dcp == null) {
            throw new CertStoreUpdateFailException("There are no any certificate to reference");
        }
        this.certRef.put(refNo, dcp);
    }

    public DatabaseParameters getParameters() {
        return this.params;
    }

    public void reload() throws CertStoreUpdateFailException, CertStoreAccessFailException, CertStoreLoadingFailException {
        this.certList2Database();
        this.database2CertList();
    }

    public void start(CertStoreParams params) throws CertStoreStartFailException {
        if (!this.started) {
            try {
                this.params = (DatabaseParameters)params;
                this.establish();
                this.started = true;
                this.database2CertList();
                if (SaveHouse.roomService == null) {
                    throw new CertStoreStartFailException("Room Service error:", " the database connector required room service .");
                }
                SaveHouse.roomService.addServiceTask(this.certStoreReloader);
            }
            catch (CertStoreLoadingFailException e) {
                SaveHouse.TraceInfo("Database loading fail while try to start database certificacte store.");
            }
            catch (CertStoreAccessFailException e) {
                throw new CertStoreStartFailException("Connect error:", e.toString());
            }
            catch (SQLException e) {
                throw new CertStoreStartFailException("Connect error:", e.toString());
            }
            catch (ClassNotFoundException e) {
                throw new CertStoreStartFailException("Driver error:", e.toString());
            }
        }
    }

    public void stop() throws CertStoreStopFailException {
        try {
            if (!this.params.getDriverClass().equals(DatabaseParameters.ODBC_CLASS)) {
                this.closeConnect();
            }
            this.started = false;
            if (SaveHouse.roomService != null) {
                SaveHouse.roomService.removeTask(this.certStoreReloader);
            }
        }
        catch (SQLException e) {
            throw new CertStoreStopFailException("Close error:", e.toString());
        }
    }

    public boolean isStart() {
        return this.started;
    }

    public int getOperatorNumber() {
        return 2;
    }

    private int getCertGroupID(String cg) {
        if (cg.equalsIgnoreCase("RootCertificates")) {
            return ROOT_CERT_GROUP;
        }
        if (cg.equalsIgnoreCase("TrustedCertificates")) {
            return TRUSTED_CERT_GROUP;
        }
        if (cg.equalsIgnoreCase("ProviderCertificates")) {
            return PROVIDER_CERT_GROUP;
        }
        return ALL_CERT_GROUP;
    }

    public static String getCertID(CertProfile cp) {
        return String.valueOf(cp.getX509Cert().getIssuerX500Principal().getName()) + " - " + cp.getSerialNumber();
    }

    private CertProfile getCertFromDB(String key, String value) throws CertificateFindingFailException, CertificateException, IOException, SQLException {
        Object cp = null;
        byte[] bytes = null;
        String sql = "select * from Certification where " + key + "='" + value + "'";
        return this.getCertFromDB(sql);
    }

    private CertProfile getCertFromDB(String sql) throws CertificateFindingFailException, CertificateException, IOException, SQLException {
        CertProfile cp = null;
        byte[] bytes = null;
        ResultSet resultSet = this.doQuery(sql);
        if (resultSet.first()) {
            if (this.params.getDriverClass().equals(DatabaseParameters.ODBC_CLASS) || this.params.getDriverClass().equals(DatabaseParameters.MSSQL_SERVER_CLASS)) {
                bytes = resultSet.getBytes("Cert");
            } else {
                Blob blob = resultSet.getBlob("Cert");
                bytes = blob.getBytes(1L, (int)blob.length());
            }
            ByteArrayInputStream byteIS = new ByteArrayInputStream(bytes);
            cp = CertProfile.decode(byteIS);
        }
        resultSet.close();
        if (cp == null) {
            throw new CertificateFindingFailException("DBCertStore", " Certificate not found as sql command, " + sql);
        }
        return cp;
    }

    private void mappingCertDB(String refNo, DBCertProfile cert) throws ClassNotFoundException, SQLException, CertStoreUpdateFailException {
        int priority = 1;
        String status = "A";
        boolean isNew = true;
        String certID = DBCertStore.getCertID(cert);
        String sql = "select * from CertMapping where CertMapping.CertID='" + certID + "' AND CertMapping.Ref_ID='" + refNo + "'";
        ResultSet resultSet = this.doQuery(sql);
        if (resultSet.first()) {
            isNew = false;
        }
        resultSet.close();
        boolean success = false;
        if (isNew) {
            this.connect.setAutoCommit(false);
            PreparedStatement ps = this.connect.prepareStatement("INSERT INTO CertMapping( Ref_ID , CertID , Priority , Status ) values(?,?,?,?)");
            ps.setString(1, refNo);
            ps.setString(2, certID);
            ps.setInt(3, priority);
            ps.setString(4, status);
            if (ps.executeUpdate() > 0) {
                success = true;
            }
            ps.close();
            if (success) {
                this.traceInfo("Create mapping record for ref no:" + refNo + " with certificate: " + certID);
                this.connect.commit();
            } else {
                this.connect.rollback();
            }
            this.connect.setAutoCommit(true);
        }
    }

    private void certList2Database() throws CertStoreUpdateFailException {
        Iterator certs = this.certList.getIterator();
        while (certs.hasNext()) {
            DBCertProfile dcp = (DBCertProfile)certs.next();
            if (dcp.state == TOBE_DELETEED_PROFILE) {
                try {
                    this.deleteCertDB(dcp);
                }
                catch (SQLException e) {
                    throw new CertStoreUpdateFailException("Error while delete certificate from db, " + e.getMessage());
                }
                dcp.state = READY_PROFILE;
                continue;
            }
            if (dcp.state != TOBE_INSERT_PROFILE) continue;
            try {
                this.setCert2DB(dcp);
            }
            catch (CertPackageException e) {
                throw new CertStoreUpdateFailException("Error while register certificate to db, " + e.getMessage());
            }
            catch (ASN1Exception e) {
                throw new CertStoreUpdateFailException("Error while register certificate to db, " + e.getMessage());
            }
            catch (SQLException e) {
                throw new CertStoreUpdateFailException("Error while register certificate to db, " + e.getMessage());
            }
            dcp.state = READY_PROFILE;
        }
    }

    private void setCert2DB(DBCertProfile cert) throws ASN1Exception, SQLException, CertPackageException {
        String certID = DBCertStore.getCertID(cert);
        String commonName = cert.getSubjectDN().getCommonName();
        String subjectNames = cert.getSubjectDN().getSubject();
        String issuer = cert.getIssuerDN().getSubject();
        String eMailAddress = cert.getSubjectDN().getEMailAddress();
        byte[] certByte = cert.getBytes();
        this.group = cert.isCA() ? ROOT_CERT_GROUP : TRUSTED_CERT_GROUP;
        boolean isNew = true;
        String sql = "select * from Certification where Certification.CertID='" + certID + "'";
        ResultSet resultSet = this.doQuery(sql);
        if (resultSet.first()) {
            isNew = false;
        }
        resultSet.close();
        if (isNew) {
            boolean success = false;
            this.connect.setAutoCommit(false);
            PreparedStatement ps = this.connect.prepareStatement("INSERT INTO Certification(CertId,CommonName,SubjectName,Issuer,emailAddress,Cert) VALUES(?,?,?,?,?,?)");
            ps.setString(1, certID);
            ps.setString(2, commonName);
            ps.setString(3, subjectNames);
            ps.setString(4, issuer);
            ps.setString(5, eMailAddress);
            ByteArrayInputStream byteIS = new ByteArrayInputStream(certByte);
            ps.setBinaryStream(6, (InputStream)byteIS, certByte.length);
            PreparedStatement ps2 = this.connect.prepareStatement("INSERT INTO CertGroupping ( CertID, CertGroupID ) values(?,?)");
            ps2.setString(1, certID);
            ps2.setInt(2, this.group);
            if (ps.executeUpdate() > 0 && ps2.executeUpdate() > 0) {
                success = true;
            }
            ps2.close();
            ps.close();
            if (success) {
                this.traceInfo("Insert new certificate: " + certID);
                this.connect.commit();
            } else {
                this.connect.rollback();
            }
            this.connect.setAutoCommit(true);
        }
    }

    private void deleteCertDB(CertProfile cert) throws SQLException {
        this.connect.setAutoCommit(false);
        Statement stmt = this.connect.createStatement();
        boolean success = false;
        String certID = DBCertStore.getCertID(cert);
        String sqlDelMapping = "DELETE FROM CertMapping WHERE CertID='" + certID + "'";
        String sqlDelGroupping = "DELETE FROM CertGroupping WHERE CertID='" + certID + "'";
        String sqlDelCert = "DELETE FROM Certification WHERE CertID='" + certID + "'";
        if (stmt.executeUpdate(sqlDelMapping) >= 0 && stmt.executeUpdate(sqlDelGroupping) >= 0 && stmt.executeUpdate(sqlDelCert) >= 0) {
            success = true;
        }
        if (success) {
            this.traceInfo("Remove certificate: " + certID);
            this.connect.commit();
        } else {
            this.connect.rollback();
        }
        stmt.close();
        this.connect.setAutoCommit(true);
    }

    private void database2CertList() throws CertStoreAccessFailException, CertStoreLoadingFailException {
        String error;
        int ignore;
        ArrayList<CertProfile> cl;
        block17: {
            cl = new ArrayList<CertProfile>();
            ignore = 0;
            error = "";
            try {
                int row = 0;
                byte[] bytes = null;
                this.connect.setAutoCommit(true);
                ResultSet resultSet = this.getCertResultSet("AllCertificates");
                resultSet.last();
                row = resultSet.getRow();
                if (row <= 0) break block17;
                error = String.valueOf(error) + " Error while get certificates from database ";
                resultSet.first();
                while (!resultSet.isAfterLast()) {
                    if (this.params.getDriverClass().equals(DatabaseParameters.ODBC_CLASS) || this.params.getDriverClass().equals(DatabaseParameters.MSSQL_SERVER_CLASS)) {
                        bytes = resultSet.getBytes("cert");
                    } else {
                        Blob blob = resultSet.getBlob("cert");
                        bytes = blob.getBytes(1L, (int)blob.length());
                    }
                    ByteArrayInputStream byteIS = new ByteArrayInputStream(bytes);
                    try {
                        cl.add(CertProfile.decode(byteIS));
                    }
                    catch (CertificateException e) {
                        error = String.valueOf(error) + "\nIgnore Cert #" + ++ignore + e.getMessage();
                    }
                    resultSet.next();
                }
                resultSet.close();
            }
            catch (IOException e) {
                throw new CertStoreAccessFailException("Connection error, " + e.toString());
            }
            catch (SQLException e) {
                throw new CertStoreAccessFailException("Database error, " + e.toString());
            }
        }
        this.certList.removeAll();
        this.rootCertList.removeAll();
        this.trustCertList.removeAll();
        this.pvdCertList.removeAll();
        error = String.valueOf(error) + " Error while filter certificates to cert list ";
        if (cl.size() > 1) {
            this.traceInfo("===> Update certificate list from database. " + cl.size());
        }
        int c = 0;
        while (c < cl.size()) {
            try {
                CertProfile cp = (CertProfile)cl.get(c);
                DBCertProfile dcp = (DBCertProfile)this.certList.getCert(cp);
                if (dcp == null) {
                    DBCertProfile dbcert = new DBCertProfile(cp);
                    if (cp.isCA()) {
                        this.rootCertList.setCert(dbcert);
                    } else {
                        this.trustCertList.setCert(dbcert);
                    }
                    this.certList.setCert(dbcert);
                } else {
                    dcp.state = READY_PROFILE;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                error = String.valueOf(error) + "\nIgnore Cert #" + ++ignore + e.getMessage();
            }
            ++c;
        }
        if (ignore > 0) {
            throw new CertStoreLoadingFailException("There are " + ignore + " certificates not loaded from database as following message: " + error);
        }
    }

    private ResultSet getCertResultSet(String certGroup) throws SQLException {
        int grpId = this.getCertGroupID(certGroup);
        String select = "SELECT A.CertID as certid, A.SubjectName as subjectname, A.Cert as cert, B.CertGroupID as groupid, B.CertGroupName as groupname FROM Certification A, CertGroup B, CertGroupping C ";
        String where = " WHERE ";
        if (grpId > 0) {
            where = String.valueOf(where) + " (b.CertGroupID = " + grpId + ") AND ";
        }
        where = String.valueOf(where) + "( B.CertGroupID = C.CertGroupID AND C.CertID = A.CertID )";
        String sql = String.valueOf(select) + where;
        return this.doQuery(sql);
    }

    private ResultSet doQuery(String query) throws SQLException {
        Statement stmt = this.connect.createStatement(1004, 1007);
        ResultSet resultSet = stmt.executeQuery(query);
        return resultSet;
    }

    private void closeConnect() throws SQLException {
        this.connect.close();
    }

    private void reConnection() throws SQLException, ClassNotFoundException {
        if (this.connect == null || this.connect.isClosed()) {
            this.establish();
        }
    }

    private void establish() throws SQLException, ClassNotFoundException {
        String url = this.params.getDriverURL();
        String user = this.params.getUser();
        String password = this.params.getPassword();
        Class.forName(this.params.getDriverClass());
        if (url.equalsIgnoreCase(DatabaseParameters.UNDEFINE)) {
            this.traceInfo("! Can not establish database connection :" + url);
            throw new SQLException("The supplied parameter is not correct");
        }
        this.connect = user.equalsIgnoreCase(DatabaseParameters.UNDEFINE) ? DriverManager.getConnection(url) : DriverManager.getConnection(url, user, password);
        this.traceInfo("Succesfully to establish database connection :" + url);
        this.connect.setAutoCommit(false);
    }

    public class DBCertProfile
    extends InternalCertProfile {
        public int state;

        public DBCertProfile(CertProfile cer) {
            super(cer, DBCertStore.getCertID(cer));
            this.state = READY_PROFILE;
        }

        public boolean is(CertProfile cp) {
            String certID = DBCertStore.getCertID(cp);
            return certID.compareTo(this.getFriendlyName()) == 0;
        }

        public boolean is(InternalCertProfile icp) {
            return icp.getFriendlyName().compareTo(this.getFriendlyName()) == 0;
        }

        public boolean isSettable() {
            return this.state == 0;
        }
    }
}

