/*
 * Decompiled with CFR 0.152.
 */
package th.co.oga.security.pki.Operator.MozillaJSS;

import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import th.co.oga.security.pki.Algorithm.AlgorithmProfile;
import th.co.oga.security.pki.Algorithm.AlgorithmSet;
import th.co.oga.security.pki.Algorithm.AlgorithmSetName;
import th.co.oga.security.pki.Algorithm.AlgorithmSupportTable;
import th.co.oga.security.pki.OIDs;

public class JSSAlgorithm
extends AlgorithmSupportTable {
    public JSSAlgorithm() {
        super("Mozilla-JSS V 3.9");
        this.types.add(AlgorithmSetName.MESSAGE_DIGEST);
        this.types.add(AlgorithmSetName.ENCRYPTION_ALGO);
        this.types.add(AlgorithmSetName.ENCRYPT_SYMETRIC);
        this.types.add(AlgorithmSetName.ENCRYPT_ASYMETRIC);
        this.types.add(AlgorithmSetName.PASSWORD_BASE_ENCRYPTION);
        this.types.add(AlgorithmSetName.SECRET_KEY_ALGO);
        this.types.add(AlgorithmSetName.KEY_GEN_ALGO);
        this.types.add(AlgorithmSetName.KEY_PAIR_ALGO);
        this.types.add(AlgorithmSetName.KEY_WRAP_ALGO);
        this.types.add(AlgorithmSetName.SIGNATURE_ALGO);
        this.types.add(AlgorithmSetName.SECURE_RANDOM);
        this.set = new AlgorithmSet[this.types.size()];
        int i = 0;
        while (i < this.types.size()) {
            this.set[i] = new AlgorithmSet((AlgorithmSetName)this.types.get(i));
            ++i;
        }
        int idx = this.types.indexOf(AlgorithmSetName.MESSAGE_DIGEST);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.SHA1, "SHA1", "SHA-1:SHA:SHA1"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.MD2, "MD2"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.MD5, "MD5"));
        idx = this.types.indexOf(AlgorithmSetName.ENCRYPTION_ALGO);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.rsaEncryption, "RSA"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.dsaEncryption, "DSA"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES, "DES"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DESede, "DESede"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.AES, "AES"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.RC4, "RC4"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.notDefine, "RC2"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_CBC_pad, "DES_CBC_PKCS5Padding", "DES/CBC/PKCS5Padding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_ECB, "DES_ECB", "DES/ECB/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_CBC, "DES_CBC", "DES/CBC/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_3CBC_pad, "DESede_CBC_PKCSPadding", "DESede/CBC/PKCS5Padding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_3ECB, "DESede_ECB", "DESede/ECB/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_3CBC, "DESede_CBC", "DESede/CBC/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.AES_256CBC_Pad, "AES_CBC256_PKCS5Padding", "AES/CBC256/PKCS5Padding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.RC2_CBC_PAD, "RC2_CBC_PKCS5Padding", "RC2/CBC/PKCS5Padding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.rsaEncryption, "RSA"));
        idx = this.types.indexOf(AlgorithmSetName.ENCRYPT_SYMETRIC);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_CBC_pad, "DES_CBC_PKCS5Padding", "DES/CBC/PKCS5Padding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_ECB, "DES_ECB", "DES/ECB/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_CBC, "DES_CBC", "DES/CBC/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_3CBC_pad, "DESede_CBC_PKCSPadding", "DESede/CBC/PKCS5Padding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_3ECB, "DESede_ECB", "DESede/ECB/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES_3CBC, "DESede_CBC", "DESede/CBC/NoPadding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.AES_256CBC_Pad, "AES_CBC256_PKCS5Padding", "AES/CBC256/PKCS5Padding"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.RC2_CBC_PAD, "RC2_CBC_PKCS5Padding", "RC2/CBC/PKCS5Padding"));
        idx = this.types.indexOf(AlgorithmSetName.ENCRYPT_ASYMETRIC);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.rsaEncryption, "RSA"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.dsaEncryption, "DSA"));
        idx = this.types.indexOf(AlgorithmSetName.PASSWORD_BASE_ENCRYPTION);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithMD2AndDES_CBC, "PBEWithMD2AndDESCBC", "PBE/MD2/DES/CBC"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithMD5AndDES_CBC, "PBEWithMD5AndDESCBC", "PBE/MD5/DES/CBC"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithSHA1AndDES_CBC, "PBEWithSHA1AndDESCBC", "PBE/SHA1/DES/CBC"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithSHA1AndDES3_CBC, "PBEWithSHA1AndDESedeCBC", "PBE/SHA1/DESEDE/CBC"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithSHA1AndRC2128_CBC, "PBEWithSHA1And128RC2CBC", "PBE/SHA1/RC2/128/CBC"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithSHA1AndRC240_CBC, "PBEWithSHA1And40RC2CBC", "PBE/SHA1/RC2/40/CBC"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithSHA1AndRC4128, "PBEWithSHA1And128RC4", "PBE/SHA1/RC4/128"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithSHA1AndRC440, "PBEWithSHA1And40RC4", "PBE/SHA1/RC4/40"));
        idx = this.types.indexOf(AlgorithmSetName.SECRET_KEY_ALGO);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.AES, "AES"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES, "DES"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DESede, "DESede"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.notDefine, "RC2"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.RC4, "RC4"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.notDefine, "PBAHmacSHA1"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithMD5AndDES_CBC, "PBEWithMD5AndDES"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithSHA1AndDES_CBC, "PBEWithSHA1AndDES"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithSHA1AndDES3_CBC, "PBEWithSHA1AndDESede"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.pbeWithSHA1AndRC4128, "PBEWithSHA1And128RC4"));
        idx = this.types.indexOf(AlgorithmSetName.KEY_GEN_ALGO);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.AES, "AES"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DES, "DES"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.DESede, "DESede", "DES3/DESEDE"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.notDefine, "RC2"));
        idx = this.types.indexOf(AlgorithmSetName.KEY_PAIR_ALGO);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.rsaEncryption, "RSA"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.dsaEncryption, "DSA"));
        idx = this.types.indexOf(AlgorithmSetName.KEY_WRAP_ALGO);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.rsaEncryption, "RSA"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.dsaEncryption, "DSA"));
        idx = this.types.indexOf(AlgorithmSetName.SIGNATURE_ALGO);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.rsaWithSHA1, "SHA1withRSA", "RSA/SHA1/SHA-1"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.rsaWithMD5, "MD5withRSA", "RSA/MD5"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.rsaWithMD2, "MD2withRSA", "RSA/MD2"));
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.dsaWithSHA1, "DSAwithSHA1", "DSA/SHA1/SHA-1"));
        idx = this.types.indexOf(AlgorithmSetName.SECURE_RANDOM);
        this.set[idx].addAlgorithm(new AlgorithmProfile(OIDs.PRNG_JSS_PKCS11, "PKCS11PRNG"));
    }

    public static AlgorithmIdentifier getAlgoID(String oid) {
        return new AlgorithmIdentifier(new OBJECT_IDENTIFIER(oid));
    }
}

